# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceInventory(object):
    """
    The inventory of WebLogic domains and managed instances in the selected compartment.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceInventory object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param wls_domain_count:
            The value to assign to the wls_domain_count property of this ResourceInventory.
        :type wls_domain_count: int

        :param wls_domain_not_in_latest_patch_count:
            The value to assign to the wls_domain_not_in_latest_patch_count property of this ResourceInventory.
        :type wls_domain_not_in_latest_patch_count: int

        :param wls_domain_with_patch_readiness_warning_count:
            The value to assign to the wls_domain_with_patch_readiness_warning_count property of this ResourceInventory.
        :type wls_domain_with_patch_readiness_warning_count: int

        :param wls_domain_with_patch_readiness_error_count:
            The value to assign to the wls_domain_with_patch_readiness_error_count property of this ResourceInventory.
        :type wls_domain_with_patch_readiness_error_count: int

        :param managed_instance_count:
            The value to assign to the managed_instance_count property of this ResourceInventory.
        :type managed_instance_count: int

        :param managed_instance_with_patch_readiness_warning_count:
            The value to assign to the managed_instance_with_patch_readiness_warning_count property of this ResourceInventory.
        :type managed_instance_with_patch_readiness_warning_count: int

        :param managed_instance_with_patch_readiness_error_count:
            The value to assign to the managed_instance_with_patch_readiness_error_count property of this ResourceInventory.
        :type managed_instance_with_patch_readiness_error_count: int

        """
        self.swagger_types = {
            'wls_domain_count': 'int',
            'wls_domain_not_in_latest_patch_count': 'int',
            'wls_domain_with_patch_readiness_warning_count': 'int',
            'wls_domain_with_patch_readiness_error_count': 'int',
            'managed_instance_count': 'int',
            'managed_instance_with_patch_readiness_warning_count': 'int',
            'managed_instance_with_patch_readiness_error_count': 'int'
        }
        self.attribute_map = {
            'wls_domain_count': 'wlsDomainCount',
            'wls_domain_not_in_latest_patch_count': 'wlsDomainNotInLatestPatchCount',
            'wls_domain_with_patch_readiness_warning_count': 'wlsDomainWithPatchReadinessWarningCount',
            'wls_domain_with_patch_readiness_error_count': 'wlsDomainWithPatchReadinessErrorCount',
            'managed_instance_count': 'managedInstanceCount',
            'managed_instance_with_patch_readiness_warning_count': 'managedInstanceWithPatchReadinessWarningCount',
            'managed_instance_with_patch_readiness_error_count': 'managedInstanceWithPatchReadinessErrorCount'
        }
        self._wls_domain_count = None
        self._wls_domain_not_in_latest_patch_count = None
        self._wls_domain_with_patch_readiness_warning_count = None
        self._wls_domain_with_patch_readiness_error_count = None
        self._managed_instance_count = None
        self._managed_instance_with_patch_readiness_warning_count = None
        self._managed_instance_with_patch_readiness_error_count = None

    @property
    def wls_domain_count(self):
        """
        **[Required]** Gets the wls_domain_count of this ResourceInventory.
        The number of WebLogic domains discovered in the selected compartment.


        :return: The wls_domain_count of this ResourceInventory.
        :rtype: int
        """
        return self._wls_domain_count

    @wls_domain_count.setter
    def wls_domain_count(self, wls_domain_count):
        """
        Sets the wls_domain_count of this ResourceInventory.
        The number of WebLogic domains discovered in the selected compartment.


        :param wls_domain_count: The wls_domain_count of this ResourceInventory.
        :type: int
        """
        self._wls_domain_count = wls_domain_count

    @property
    def wls_domain_not_in_latest_patch_count(self):
        """
        Gets the wls_domain_not_in_latest_patch_count of this ResourceInventory.
        The number of WebLogic domains that are not in the latest patch.


        :return: The wls_domain_not_in_latest_patch_count of this ResourceInventory.
        :rtype: int
        """
        return self._wls_domain_not_in_latest_patch_count

    @wls_domain_not_in_latest_patch_count.setter
    def wls_domain_not_in_latest_patch_count(self, wls_domain_not_in_latest_patch_count):
        """
        Sets the wls_domain_not_in_latest_patch_count of this ResourceInventory.
        The number of WebLogic domains that are not in the latest patch.


        :param wls_domain_not_in_latest_patch_count: The wls_domain_not_in_latest_patch_count of this ResourceInventory.
        :type: int
        """
        self._wls_domain_not_in_latest_patch_count = wls_domain_not_in_latest_patch_count

    @property
    def wls_domain_with_patch_readiness_warning_count(self):
        """
        Gets the wls_domain_with_patch_readiness_warning_count of this ResourceInventory.
        The number of WebLogic domains that have warnings in the patch readiness check.


        :return: The wls_domain_with_patch_readiness_warning_count of this ResourceInventory.
        :rtype: int
        """
        return self._wls_domain_with_patch_readiness_warning_count

    @wls_domain_with_patch_readiness_warning_count.setter
    def wls_domain_with_patch_readiness_warning_count(self, wls_domain_with_patch_readiness_warning_count):
        """
        Sets the wls_domain_with_patch_readiness_warning_count of this ResourceInventory.
        The number of WebLogic domains that have warnings in the patch readiness check.


        :param wls_domain_with_patch_readiness_warning_count: The wls_domain_with_patch_readiness_warning_count of this ResourceInventory.
        :type: int
        """
        self._wls_domain_with_patch_readiness_warning_count = wls_domain_with_patch_readiness_warning_count

    @property
    def wls_domain_with_patch_readiness_error_count(self):
        """
        Gets the wls_domain_with_patch_readiness_error_count of this ResourceInventory.
        The number of WebLogic domains that have errors in the patch readiness check.


        :return: The wls_domain_with_patch_readiness_error_count of this ResourceInventory.
        :rtype: int
        """
        return self._wls_domain_with_patch_readiness_error_count

    @wls_domain_with_patch_readiness_error_count.setter
    def wls_domain_with_patch_readiness_error_count(self, wls_domain_with_patch_readiness_error_count):
        """
        Sets the wls_domain_with_patch_readiness_error_count of this ResourceInventory.
        The number of WebLogic domains that have errors in the patch readiness check.


        :param wls_domain_with_patch_readiness_error_count: The wls_domain_with_patch_readiness_error_count of this ResourceInventory.
        :type: int
        """
        self._wls_domain_with_patch_readiness_error_count = wls_domain_with_patch_readiness_error_count

    @property
    def managed_instance_count(self):
        """
        **[Required]** Gets the managed_instance_count of this ResourceInventory.
        The number of managed instances in the selected compartment.


        :return: The managed_instance_count of this ResourceInventory.
        :rtype: int
        """
        return self._managed_instance_count

    @managed_instance_count.setter
    def managed_instance_count(self, managed_instance_count):
        """
        Sets the managed_instance_count of this ResourceInventory.
        The number of managed instances in the selected compartment.


        :param managed_instance_count: The managed_instance_count of this ResourceInventory.
        :type: int
        """
        self._managed_instance_count = managed_instance_count

    @property
    def managed_instance_with_patch_readiness_warning_count(self):
        """
        Gets the managed_instance_with_patch_readiness_warning_count of this ResourceInventory.
        The number of managed instance that have WebLogic domains with warnings in the patch readiness check.


        :return: The managed_instance_with_patch_readiness_warning_count of this ResourceInventory.
        :rtype: int
        """
        return self._managed_instance_with_patch_readiness_warning_count

    @managed_instance_with_patch_readiness_warning_count.setter
    def managed_instance_with_patch_readiness_warning_count(self, managed_instance_with_patch_readiness_warning_count):
        """
        Sets the managed_instance_with_patch_readiness_warning_count of this ResourceInventory.
        The number of managed instance that have WebLogic domains with warnings in the patch readiness check.


        :param managed_instance_with_patch_readiness_warning_count: The managed_instance_with_patch_readiness_warning_count of this ResourceInventory.
        :type: int
        """
        self._managed_instance_with_patch_readiness_warning_count = managed_instance_with_patch_readiness_warning_count

    @property
    def managed_instance_with_patch_readiness_error_count(self):
        """
        Gets the managed_instance_with_patch_readiness_error_count of this ResourceInventory.
        The number of managed instance that have WebLogic domains with errors in the patch readiness check.


        :return: The managed_instance_with_patch_readiness_error_count of this ResourceInventory.
        :rtype: int
        """
        return self._managed_instance_with_patch_readiness_error_count

    @managed_instance_with_patch_readiness_error_count.setter
    def managed_instance_with_patch_readiness_error_count(self, managed_instance_with_patch_readiness_error_count):
        """
        Sets the managed_instance_with_patch_readiness_error_count of this ResourceInventory.
        The number of managed instance that have WebLogic domains with errors in the patch readiness check.


        :param managed_instance_with_patch_readiness_error_count: The managed_instance_with_patch_readiness_error_count of this ResourceInventory.
        :type: int
        """
        self._managed_instance_with_patch_readiness_error_count = managed_instance_with_patch_readiness_error_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
