# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AgreementRecord(object):
    """
    A record showing that the terms of use agreement for the WebLogic management service was accepted for a domain.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AgreementRecord object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_accepted:
            The value to assign to the time_accepted property of this AgreementRecord.
        :type time_accepted: datetime

        :param agreement_uuid:
            The value to assign to the agreement_uuid property of this AgreementRecord.
        :type agreement_uuid: str

        :param agreement_signature:
            The value to assign to the agreement_signature property of this AgreementRecord.
        :type agreement_signature: str

        """
        self.swagger_types = {
            'time_accepted': 'datetime',
            'agreement_uuid': 'str',
            'agreement_signature': 'str'
        }
        self.attribute_map = {
            'time_accepted': 'timeAccepted',
            'agreement_uuid': 'agreementUuid',
            'agreement_signature': 'agreementSignature'
        }
        self._time_accepted = None
        self._agreement_uuid = None
        self._agreement_signature = None

    @property
    def time_accepted(self):
        """
        **[Required]** Gets the time_accepted of this AgreementRecord.
        The accepted time for the agreement record.


        :return: The time_accepted of this AgreementRecord.
        :rtype: datetime
        """
        return self._time_accepted

    @time_accepted.setter
    def time_accepted(self, time_accepted):
        """
        Sets the time_accepted of this AgreementRecord.
        The accepted time for the agreement record.


        :param time_accepted: The time_accepted of this AgreementRecord.
        :type: datetime
        """
        self._time_accepted = time_accepted

    @property
    def agreement_uuid(self):
        """
        **[Required]** Gets the agreement_uuid of this AgreementRecord.
        The ID of the accepted agreement.


        :return: The agreement_uuid of this AgreementRecord.
        :rtype: str
        """
        return self._agreement_uuid

    @agreement_uuid.setter
    def agreement_uuid(self, agreement_uuid):
        """
        Sets the agreement_uuid of this AgreementRecord.
        The ID of the accepted agreement.


        :param agreement_uuid: The agreement_uuid of this AgreementRecord.
        :type: str
        """
        self._agreement_uuid = agreement_uuid

    @property
    def agreement_signature(self):
        """
        **[Required]** Gets the agreement_signature of this AgreementRecord.
        The agreement signature.


        :return: The agreement_signature of this AgreementRecord.
        :rtype: str
        """
        return self._agreement_signature

    @agreement_signature.setter
    def agreement_signature(self, agreement_signature):
        """
        Sets the agreement_signature of this AgreementRecord.
        The agreement signature.


        :param agreement_signature: The agreement_signature of this AgreementRecord.
        :type: str
        """
        self._agreement_signature = agreement_signature

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
