# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .create_flex_tunnel_configuration_details import CreateFlexTunnelConfigurationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateGreFlexTunnelConfigurationDetails(CreateFlexTunnelConfigurationDetails):
    """
    The gre tunnel configuration create details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateGreFlexTunnelConfigurationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.CreateGreFlexTunnelConfigurationDetails.tunnel_type` attribute
        of this class is ``GRE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tunnel_type:
            The value to assign to the tunnel_type property of this CreateGreFlexTunnelConfigurationDetails.
            Allowed values for this property are: "GRE"
        :type tunnel_type: str

        :param customer_tunnel_ip:
            The value to assign to the customer_tunnel_ip property of this CreateGreFlexTunnelConfigurationDetails.
        :type customer_tunnel_ip: str

        :param oracle_tunnel_ip:
            The value to assign to the oracle_tunnel_ip property of this CreateGreFlexTunnelConfigurationDetails.
        :type oracle_tunnel_ip: str

        :param bgp_session:
            The value to assign to the bgp_session property of this CreateGreFlexTunnelConfigurationDetails.
        :type bgp_session: oci.vn_monitoring.models.CreateFlexTunnelBgpSessionDetails

        """
        self.swagger_types = {
            'tunnel_type': 'str',
            'customer_tunnel_ip': 'str',
            'oracle_tunnel_ip': 'str',
            'bgp_session': 'CreateFlexTunnelBgpSessionDetails'
        }
        self.attribute_map = {
            'tunnel_type': 'tunnelType',
            'customer_tunnel_ip': 'customerTunnelIp',
            'oracle_tunnel_ip': 'oracleTunnelIp',
            'bgp_session': 'bgpSession'
        }
        self._tunnel_type = None
        self._customer_tunnel_ip = None
        self._oracle_tunnel_ip = None
        self._bgp_session = None
        self._tunnel_type = 'GRE'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
