# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricNameConfigurationDetails(object):
    """
    Metric name generation overriding configurations.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricNameConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_prefix_with_collector_type:
            The value to assign to the is_prefix_with_collector_type property of this MetricNameConfigurationDetails.
        :type is_prefix_with_collector_type: bool

        :param exclude_pattern_on_prefix:
            The value to assign to the exclude_pattern_on_prefix property of this MetricNameConfigurationDetails.
        :type exclude_pattern_on_prefix: str

        """
        self.swagger_types = {
            'is_prefix_with_collector_type': 'bool',
            'exclude_pattern_on_prefix': 'str'
        }
        self.attribute_map = {
            'is_prefix_with_collector_type': 'isPrefixWithCollectorType',
            'exclude_pattern_on_prefix': 'excludePatternOnPrefix'
        }
        self._is_prefix_with_collector_type = None
        self._exclude_pattern_on_prefix = None

    @property
    def is_prefix_with_collector_type(self):
        """
        Gets the is_prefix_with_collector_type of this MetricNameConfigurationDetails.
        is prefixing the metric with collector type.


        :return: The is_prefix_with_collector_type of this MetricNameConfigurationDetails.
        :rtype: bool
        """
        return self._is_prefix_with_collector_type

    @is_prefix_with_collector_type.setter
    def is_prefix_with_collector_type(self, is_prefix_with_collector_type):
        """
        Sets the is_prefix_with_collector_type of this MetricNameConfigurationDetails.
        is prefixing the metric with collector type.


        :param is_prefix_with_collector_type: The is_prefix_with_collector_type of this MetricNameConfigurationDetails.
        :type: bool
        """
        self._is_prefix_with_collector_type = is_prefix_with_collector_type

    @property
    def exclude_pattern_on_prefix(self):
        """
        Gets the exclude_pattern_on_prefix of this MetricNameConfigurationDetails.
        String pattern to be removed from the prefix of the metric name.


        :return: The exclude_pattern_on_prefix of this MetricNameConfigurationDetails.
        :rtype: str
        """
        return self._exclude_pattern_on_prefix

    @exclude_pattern_on_prefix.setter
    def exclude_pattern_on_prefix(self, exclude_pattern_on_prefix):
        """
        Sets the exclude_pattern_on_prefix of this MetricNameConfigurationDetails.
        String pattern to be removed from the prefix of the metric name.


        :param exclude_pattern_on_prefix: The exclude_pattern_on_prefix of this MetricNameConfigurationDetails.
        :type: str
        """
        self._exclude_pattern_on_prefix = exclude_pattern_on_prefix

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
