# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CollectdResourceNameConfigurationDetails(object):
    """
    Resource name generation overriding configurations for collectd resource types.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CollectdResourceNameConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param suffix:
            The value to assign to the suffix property of this CollectdResourceNameConfigurationDetails.
        :type suffix: str

        :param include_properties:
            The value to assign to the include_properties property of this CollectdResourceNameConfigurationDetails.
        :type include_properties: list[str]

        :param exclude_properties:
            The value to assign to the exclude_properties property of this CollectdResourceNameConfigurationDetails.
        :type exclude_properties: list[str]

        """
        self.swagger_types = {
            'suffix': 'str',
            'include_properties': 'list[str]',
            'exclude_properties': 'list[str]'
        }
        self.attribute_map = {
            'suffix': 'suffix',
            'include_properties': 'includeProperties',
            'exclude_properties': 'excludeProperties'
        }
        self._suffix = None
        self._include_properties = None
        self._exclude_properties = None

    @property
    def suffix(self):
        """
        Gets the suffix of this CollectdResourceNameConfigurationDetails.
        String to be suffixed to the resource name.


        :return: The suffix of this CollectdResourceNameConfigurationDetails.
        :rtype: str
        """
        return self._suffix

    @suffix.setter
    def suffix(self, suffix):
        """
        Sets the suffix of this CollectdResourceNameConfigurationDetails.
        String to be suffixed to the resource name.


        :param suffix: The suffix of this CollectdResourceNameConfigurationDetails.
        :type: str
        """
        self._suffix = suffix

    @property
    def include_properties(self):
        """
        Gets the include_properties of this CollectdResourceNameConfigurationDetails.
        List of property names to be included.


        :return: The include_properties of this CollectdResourceNameConfigurationDetails.
        :rtype: list[str]
        """
        return self._include_properties

    @include_properties.setter
    def include_properties(self, include_properties):
        """
        Sets the include_properties of this CollectdResourceNameConfigurationDetails.
        List of property names to be included.


        :param include_properties: The include_properties of this CollectdResourceNameConfigurationDetails.
        :type: list[str]
        """
        self._include_properties = include_properties

    @property
    def exclude_properties(self):
        """
        Gets the exclude_properties of this CollectdResourceNameConfigurationDetails.
        List of property names to be excluded.


        :return: The exclude_properties of this CollectdResourceNameConfigurationDetails.
        :rtype: list[str]
        """
        return self._exclude_properties

    @exclude_properties.setter
    def exclude_properties(self, exclude_properties):
        """
        Sets the exclude_properties of this CollectdResourceNameConfigurationDetails.
        List of property names to be excluded.


        :param exclude_properties: The exclude_properties of this CollectdResourceNameConfigurationDetails.
        :type: list[str]
        """
        self._exclude_properties = exclude_properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
