# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AvailabilityMetricsDetails(object):
    """
    Availability metrics details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AvailabilityMetricsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metrics:
            The value to assign to the metrics property of this AvailabilityMetricsDetails.
        :type metrics: list[str]

        :param collection_interval_in_seconds:
            The value to assign to the collection_interval_in_seconds property of this AvailabilityMetricsDetails.
        :type collection_interval_in_seconds: int

        """
        self.swagger_types = {
            'metrics': 'list[str]',
            'collection_interval_in_seconds': 'int'
        }
        self.attribute_map = {
            'metrics': 'metrics',
            'collection_interval_in_seconds': 'collectionIntervalInSeconds'
        }
        self._metrics = None
        self._collection_interval_in_seconds = None

    @property
    def metrics(self):
        """
        **[Required]** Gets the metrics of this AvailabilityMetricsDetails.
        List of metrics used for availability calculation for the resource.


        :return: The metrics of this AvailabilityMetricsDetails.
        :rtype: list[str]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this AvailabilityMetricsDetails.
        List of metrics used for availability calculation for the resource.


        :param metrics: The metrics of this AvailabilityMetricsDetails.
        :type: list[str]
        """
        self._metrics = metrics

    @property
    def collection_interval_in_seconds(self):
        """
        **[Required]** Gets the collection_interval_in_seconds of this AvailabilityMetricsDetails.
        Availability metric collection internal in seconds.


        :return: The collection_interval_in_seconds of this AvailabilityMetricsDetails.
        :rtype: int
        """
        return self._collection_interval_in_seconds

    @collection_interval_in_seconds.setter
    def collection_interval_in_seconds(self, collection_interval_in_seconds):
        """
        Sets the collection_interval_in_seconds of this AvailabilityMetricsDetails.
        Availability metric collection internal in seconds.


        :param collection_interval_in_seconds: The collection_interval_in_seconds of this AvailabilityMetricsDetails.
        :type: int
        """
        self._collection_interval_in_seconds = collection_interval_in_seconds

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
