# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210527


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Configuration(object):
    """
    returns the service catalog mode
    """

    #: A constant which can be used with the is_service_catalog_mode property of a Configuration.
    #: This constant has a value of "ENABLED"
    IS_SERVICE_CATALOG_MODE_ENABLED = "ENABLED"

    #: A constant which can be used with the is_service_catalog_mode property of a Configuration.
    #: This constant has a value of "DISABLED"
    IS_SERVICE_CATALOG_MODE_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new Configuration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_service_catalog_mode:
            The value to assign to the is_service_catalog_mode property of this Configuration.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type is_service_catalog_mode: str

        """
        self.swagger_types = {
            'is_service_catalog_mode': 'str'
        }
        self.attribute_map = {
            'is_service_catalog_mode': 'isServiceCatalogMode'
        }
        self._is_service_catalog_mode = None

    @property
    def is_service_catalog_mode(self):
        """
        **[Required]** Gets the is_service_catalog_mode of this Configuration.
        mode of tenancy

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The is_service_catalog_mode of this Configuration.
        :rtype: str
        """
        return self._is_service_catalog_mode

    @is_service_catalog_mode.setter
    def is_service_catalog_mode(self, is_service_catalog_mode):
        """
        Sets the is_service_catalog_mode of this Configuration.
        mode of tenancy


        :param is_service_catalog_mode: The is_service_catalog_mode of this Configuration.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(is_service_catalog_mode, allowed_values):
            is_service_catalog_mode = 'UNKNOWN_ENUM_VALUE'
        self._is_service_catalog_mode = is_service_catalog_mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
