# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240301


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PsaServiceSummary(object):
    """
    An OCI service summary, that will be used as a catalog for Private Service Access.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PsaServiceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PsaServiceSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this PsaServiceSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this PsaServiceSummary.
        :type description: str

        :param fqdns:
            The value to assign to the fqdns property of this PsaServiceSummary.
        :type fqdns: list[str]

        :param is_v6_enabled:
            The value to assign to the is_v6_enabled property of this PsaServiceSummary.
        :type is_v6_enabled: bool

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'fqdns': 'list[str]',
            'is_v6_enabled': 'bool'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'fqdns': 'fqdns',
            'is_v6_enabled': 'isV6Enabled'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._fqdns = None
        self._is_v6_enabled = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PsaServiceSummary.
        A unique OCI service identifier.

        Example: `object-storage-api`


        :return: The id of this PsaServiceSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PsaServiceSummary.
        A unique OCI service identifier.

        Example: `object-storage-api`


        :param id: The id of this PsaServiceSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this PsaServiceSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this PsaServiceSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PsaServiceSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this PsaServiceSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this PsaServiceSummary.
        A description of the OCI service.


        :return: The description of this PsaServiceSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PsaServiceSummary.
        A description of the OCI service.


        :param description: The description of this PsaServiceSummary.
        :type: str
        """
        self._description = description

    @property
    def fqdns(self):
        """
        **[Required]** Gets the fqdns of this PsaServiceSummary.
        The public facing service FQDNs, which are going to be used to access the service.

        Example: `xyz.oraclecloud.com`


        :return: The fqdns of this PsaServiceSummary.
        :rtype: list[str]
        """
        return self._fqdns

    @fqdns.setter
    def fqdns(self, fqdns):
        """
        Sets the fqdns of this PsaServiceSummary.
        The public facing service FQDNs, which are going to be used to access the service.

        Example: `xyz.oraclecloud.com`


        :param fqdns: The fqdns of this PsaServiceSummary.
        :type: list[str]
        """
        self._fqdns = fqdns

    @property
    def is_v6_enabled(self):
        """
        Gets the is_v6_enabled of this PsaServiceSummary.
        This optional field will indicate that whether service is IPv6 enabled.


        :return: The is_v6_enabled of this PsaServiceSummary.
        :rtype: bool
        """
        return self._is_v6_enabled

    @is_v6_enabled.setter
    def is_v6_enabled(self, is_v6_enabled):
        """
        Sets the is_v6_enabled of this PsaServiceSummary.
        This optional field will indicate that whether service is IPv6 enabled.


        :param is_v6_enabled: The is_v6_enabled of this PsaServiceSummary.
        :type: bool
        """
        self._is_v6_enabled = is_v6_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
