# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WindowsUpdate(object):
    """
    An object that provides information about an update for a Windows instance.
    """

    #: A constant which can be used with the update_type property of a WindowsUpdate.
    #: This constant has a value of "SECURITY"
    UPDATE_TYPE_SECURITY = "SECURITY"

    #: A constant which can be used with the update_type property of a WindowsUpdate.
    #: This constant has a value of "BUGFIX"
    UPDATE_TYPE_BUGFIX = "BUGFIX"

    #: A constant which can be used with the update_type property of a WindowsUpdate.
    #: This constant has a value of "ENHANCEMENT"
    UPDATE_TYPE_ENHANCEMENT = "ENHANCEMENT"

    #: A constant which can be used with the update_type property of a WindowsUpdate.
    #: This constant has a value of "OTHER"
    UPDATE_TYPE_OTHER = "OTHER"

    #: A constant which can be used with the installable property of a WindowsUpdate.
    #: This constant has a value of "INSTALLABLE"
    INSTALLABLE_INSTALLABLE = "INSTALLABLE"

    #: A constant which can be used with the installable property of a WindowsUpdate.
    #: This constant has a value of "NOT_INSTALLABLE"
    INSTALLABLE_NOT_INSTALLABLE = "NOT_INSTALLABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new WindowsUpdate object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this WindowsUpdate.
        :type name: str

        :param update_id:
            The value to assign to the update_id property of this WindowsUpdate.
        :type update_id: str

        :param description:
            The value to assign to the description property of this WindowsUpdate.
        :type description: str

        :param update_type:
            The value to assign to the update_type property of this WindowsUpdate.
            Allowed values for this property are: "SECURITY", "BUGFIX", "ENHANCEMENT", "OTHER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type update_type: str

        :param size_in_bytes:
            The value to assign to the size_in_bytes property of this WindowsUpdate.
        :type size_in_bytes: int

        :param installable:
            The value to assign to the installable property of this WindowsUpdate.
            Allowed values for this property are: "INSTALLABLE", "NOT_INSTALLABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type installable: str

        :param installation_requirements:
            The value to assign to the installation_requirements property of this WindowsUpdate.
        :type installation_requirements: list[oci.os_management_hub.models.InstallationRequirements]

        :param is_reboot_required_for_installation:
            The value to assign to the is_reboot_required_for_installation property of this WindowsUpdate.
        :type is_reboot_required_for_installation: bool

        :param kb_article_ids:
            The value to assign to the kb_article_ids property of this WindowsUpdate.
        :type kb_article_ids: list[str]

        """
        self.swagger_types = {
            'name': 'str',
            'update_id': 'str',
            'description': 'str',
            'update_type': 'str',
            'size_in_bytes': 'int',
            'installable': 'str',
            'installation_requirements': 'list[InstallationRequirements]',
            'is_reboot_required_for_installation': 'bool',
            'kb_article_ids': 'list[str]'
        }
        self.attribute_map = {
            'name': 'name',
            'update_id': 'updateId',
            'description': 'description',
            'update_type': 'updateType',
            'size_in_bytes': 'sizeInBytes',
            'installable': 'installable',
            'installation_requirements': 'installationRequirements',
            'is_reboot_required_for_installation': 'isRebootRequiredForInstallation',
            'kb_article_ids': 'kbArticleIds'
        }
        self._name = None
        self._update_id = None
        self._description = None
        self._update_type = None
        self._size_in_bytes = None
        self._installable = None
        self._installation_requirements = None
        self._is_reboot_required_for_installation = None
        self._kb_article_ids = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this WindowsUpdate.
        Name of the Windows update.


        :return: The name of this WindowsUpdate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this WindowsUpdate.
        Name of the Windows update.


        :param name: The name of this WindowsUpdate.
        :type: str
        """
        self._name = name

    @property
    def update_id(self):
        """
        **[Required]** Gets the update_id of this WindowsUpdate.
        Unique identifier for the Windows update. Note that this is not an OCID, but is a unique identifier assigned by Microsoft.
        Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'


        :return: The update_id of this WindowsUpdate.
        :rtype: str
        """
        return self._update_id

    @update_id.setter
    def update_id(self, update_id):
        """
        Sets the update_id of this WindowsUpdate.
        Unique identifier for the Windows update. Note that this is not an OCID, but is a unique identifier assigned by Microsoft.
        Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'


        :param update_id: The update_id of this WindowsUpdate.
        :type: str
        """
        self._update_id = update_id

    @property
    def description(self):
        """
        Gets the description of this WindowsUpdate.
        Description of the update.


        :return: The description of this WindowsUpdate.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this WindowsUpdate.
        Description of the update.


        :param description: The description of this WindowsUpdate.
        :type: str
        """
        self._description = description

    @property
    def update_type(self):
        """
        **[Required]** Gets the update_type of this WindowsUpdate.
        The type of Windows update.

        Allowed values for this property are: "SECURITY", "BUGFIX", "ENHANCEMENT", "OTHER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The update_type of this WindowsUpdate.
        :rtype: str
        """
        return self._update_type

    @update_type.setter
    def update_type(self, update_type):
        """
        Sets the update_type of this WindowsUpdate.
        The type of Windows update.


        :param update_type: The update_type of this WindowsUpdate.
        :type: str
        """
        allowed_values = ["SECURITY", "BUGFIX", "ENHANCEMENT", "OTHER"]
        if not value_allowed_none_or_none_sentinel(update_type, allowed_values):
            update_type = 'UNKNOWN_ENUM_VALUE'
        self._update_type = update_type

    @property
    def size_in_bytes(self):
        """
        Gets the size_in_bytes of this WindowsUpdate.
        size of the package in bytes


        :return: The size_in_bytes of this WindowsUpdate.
        :rtype: int
        """
        return self._size_in_bytes

    @size_in_bytes.setter
    def size_in_bytes(self, size_in_bytes):
        """
        Sets the size_in_bytes of this WindowsUpdate.
        size of the package in bytes


        :param size_in_bytes: The size_in_bytes of this WindowsUpdate.
        :type: int
        """
        self._size_in_bytes = size_in_bytes

    @property
    def installable(self):
        """
        Gets the installable of this WindowsUpdate.
        Indicates whether the update can be installed using the service.

        Allowed values for this property are: "INSTALLABLE", "NOT_INSTALLABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The installable of this WindowsUpdate.
        :rtype: str
        """
        return self._installable

    @installable.setter
    def installable(self, installable):
        """
        Sets the installable of this WindowsUpdate.
        Indicates whether the update can be installed using the service.


        :param installable: The installable of this WindowsUpdate.
        :type: str
        """
        allowed_values = ["INSTALLABLE", "NOT_INSTALLABLE"]
        if not value_allowed_none_or_none_sentinel(installable, allowed_values):
            installable = 'UNKNOWN_ENUM_VALUE'
        self._installable = installable

    @property
    def installation_requirements(self):
        """
        Gets the installation_requirements of this WindowsUpdate.
        List of requirements for installing the update on the managed instance.


        :return: The installation_requirements of this WindowsUpdate.
        :rtype: list[oci.os_management_hub.models.InstallationRequirements]
        """
        return self._installation_requirements

    @installation_requirements.setter
    def installation_requirements(self, installation_requirements):
        """
        Sets the installation_requirements of this WindowsUpdate.
        List of requirements for installing the update on the managed instance.


        :param installation_requirements: The installation_requirements of this WindowsUpdate.
        :type: list[oci.os_management_hub.models.InstallationRequirements]
        """
        self._installation_requirements = installation_requirements

    @property
    def is_reboot_required_for_installation(self):
        """
        Gets the is_reboot_required_for_installation of this WindowsUpdate.
        Indicates whether a reboot is required to complete the installation of this update.


        :return: The is_reboot_required_for_installation of this WindowsUpdate.
        :rtype: bool
        """
        return self._is_reboot_required_for_installation

    @is_reboot_required_for_installation.setter
    def is_reboot_required_for_installation(self, is_reboot_required_for_installation):
        """
        Sets the is_reboot_required_for_installation of this WindowsUpdate.
        Indicates whether a reboot is required to complete the installation of this update.


        :param is_reboot_required_for_installation: The is_reboot_required_for_installation of this WindowsUpdate.
        :type: bool
        """
        self._is_reboot_required_for_installation = is_reboot_required_for_installation

    @property
    def kb_article_ids(self):
        """
        Gets the kb_article_ids of this WindowsUpdate.
        List of the Microsoft Knowledge Base Article Ids related to this Windows Update.


        :return: The kb_article_ids of this WindowsUpdate.
        :rtype: list[str]
        """
        return self._kb_article_ids

    @kb_article_ids.setter
    def kb_article_ids(self, kb_article_ids):
        """
        Sets the kb_article_ids of this WindowsUpdate.
        List of the Microsoft Knowledge Base Article Ids related to this Windows Update.


        :param kb_article_ids: The kb_article_ids of this WindowsUpdate.
        :type: list[str]
        """
        self._kb_article_ids = kb_article_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
