# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MirrorSummary(object):
    """
    Provides summary information for a software source mirror.
    """

    #: A constant which can be used with the type property of a MirrorSummary.
    #: This constant has a value of "CUSTOM"
    TYPE_CUSTOM = "CUSTOM"

    #: A constant which can be used with the type property of a MirrorSummary.
    #: This constant has a value of "VENDOR"
    TYPE_VENDOR = "VENDOR"

    #: A constant which can be used with the type property of a MirrorSummary.
    #: This constant has a value of "VERSIONED"
    TYPE_VERSIONED = "VERSIONED"

    #: A constant which can be used with the type property of a MirrorSummary.
    #: This constant has a value of "PRIVATE"
    TYPE_PRIVATE = "PRIVATE"

    #: A constant which can be used with the type property of a MirrorSummary.
    #: This constant has a value of "THIRD_PARTY"
    TYPE_THIRD_PARTY = "THIRD_PARTY"

    #: A constant which can be used with the os_family property of a MirrorSummary.
    #: This constant has a value of "ORACLE_LINUX_9"
    OS_FAMILY_ORACLE_LINUX_9 = "ORACLE_LINUX_9"

    #: A constant which can be used with the os_family property of a MirrorSummary.
    #: This constant has a value of "ORACLE_LINUX_8"
    OS_FAMILY_ORACLE_LINUX_8 = "ORACLE_LINUX_8"

    #: A constant which can be used with the os_family property of a MirrorSummary.
    #: This constant has a value of "ORACLE_LINUX_7"
    OS_FAMILY_ORACLE_LINUX_7 = "ORACLE_LINUX_7"

    #: A constant which can be used with the os_family property of a MirrorSummary.
    #: This constant has a value of "ORACLE_LINUX_6"
    OS_FAMILY_ORACLE_LINUX_6 = "ORACLE_LINUX_6"

    #: A constant which can be used with the os_family property of a MirrorSummary.
    #: This constant has a value of "WINDOWS_SERVER_2016"
    OS_FAMILY_WINDOWS_SERVER_2016 = "WINDOWS_SERVER_2016"

    #: A constant which can be used with the os_family property of a MirrorSummary.
    #: This constant has a value of "WINDOWS_SERVER_2019"
    OS_FAMILY_WINDOWS_SERVER_2019 = "WINDOWS_SERVER_2019"

    #: A constant which can be used with the os_family property of a MirrorSummary.
    #: This constant has a value of "WINDOWS_SERVER_2022"
    OS_FAMILY_WINDOWS_SERVER_2022 = "WINDOWS_SERVER_2022"

    #: A constant which can be used with the os_family property of a MirrorSummary.
    #: This constant has a value of "ALL"
    OS_FAMILY_ALL = "ALL"

    #: A constant which can be used with the arch_type property of a MirrorSummary.
    #: This constant has a value of "X86_64"
    ARCH_TYPE_X86_64 = "X86_64"

    #: A constant which can be used with the arch_type property of a MirrorSummary.
    #: This constant has a value of "AARCH64"
    ARCH_TYPE_AARCH64 = "AARCH64"

    #: A constant which can be used with the arch_type property of a MirrorSummary.
    #: This constant has a value of "I686"
    ARCH_TYPE_I686 = "I686"

    #: A constant which can be used with the arch_type property of a MirrorSummary.
    #: This constant has a value of "NOARCH"
    ARCH_TYPE_NOARCH = "NOARCH"

    #: A constant which can be used with the arch_type property of a MirrorSummary.
    #: This constant has a value of "SRC"
    ARCH_TYPE_SRC = "SRC"

    #: A constant which can be used with the arch_type property of a MirrorSummary.
    #: This constant has a value of "I386"
    ARCH_TYPE_I386 = "I386"

    #: A constant which can be used with the state property of a MirrorSummary.
    #: This constant has a value of "UNSYNCED"
    STATE_UNSYNCED = "UNSYNCED"

    #: A constant which can be used with the state property of a MirrorSummary.
    #: This constant has a value of "QUEUED"
    STATE_QUEUED = "QUEUED"

    #: A constant which can be used with the state property of a MirrorSummary.
    #: This constant has a value of "SYNCING"
    STATE_SYNCING = "SYNCING"

    #: A constant which can be used with the state property of a MirrorSummary.
    #: This constant has a value of "SYNCED"
    STATE_SYNCED = "SYNCED"

    #: A constant which can be used with the state property of a MirrorSummary.
    #: This constant has a value of "FAILED"
    STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new MirrorSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this MirrorSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this MirrorSummary.
        :type display_name: str

        :param type:
            The value to assign to the type property of this MirrorSummary.
            Allowed values for this property are: "CUSTOM", "VENDOR", "VERSIONED", "PRIVATE", "THIRD_PARTY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param os_family:
            The value to assign to the os_family property of this MirrorSummary.
            Allowed values for this property are: "ORACLE_LINUX_9", "ORACLE_LINUX_8", "ORACLE_LINUX_7", "ORACLE_LINUX_6", "WINDOWS_SERVER_2016", "WINDOWS_SERVER_2019", "WINDOWS_SERVER_2022", "ALL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type os_family: str

        :param arch_type:
            The value to assign to the arch_type property of this MirrorSummary.
            Allowed values for this property are: "X86_64", "AARCH64", "I686", "NOARCH", "SRC", "I386", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type arch_type: str

        :param state:
            The value to assign to the state property of this MirrorSummary.
            Allowed values for this property are: "UNSYNCED", "QUEUED", "SYNCING", "SYNCED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param percentage:
            The value to assign to the percentage property of this MirrorSummary.
        :type percentage: int

        :param time_last_synced:
            The value to assign to the time_last_synced property of this MirrorSummary.
        :type time_last_synced: datetime

        :param log:
            The value to assign to the log property of this MirrorSummary.
        :type log: str

        :param package_count:
            The value to assign to the package_count property of this MirrorSummary.
        :type package_count: int

        :param size:
            The value to assign to the size property of this MirrorSummary.
        :type size: int

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'type': 'str',
            'os_family': 'str',
            'arch_type': 'str',
            'state': 'str',
            'percentage': 'int',
            'time_last_synced': 'datetime',
            'log': 'str',
            'package_count': 'int',
            'size': 'int'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'type': 'type',
            'os_family': 'osFamily',
            'arch_type': 'archType',
            'state': 'state',
            'percentage': 'percentage',
            'time_last_synced': 'timeLastSynced',
            'log': 'log',
            'package_count': 'packageCount',
            'size': 'size'
        }
        self._id = None
        self._display_name = None
        self._type = None
        self._os_family = None
        self._arch_type = None
        self._state = None
        self._percentage = None
        self._time_last_synced = None
        self._log = None
        self._package_count = None
        self._size = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this MirrorSummary.
        The `OCID`__ of the software source.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this MirrorSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MirrorSummary.
        The `OCID`__ of the software source.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this MirrorSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this MirrorSummary.
        Display name of the mirror.


        :return: The display_name of this MirrorSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this MirrorSummary.
        Display name of the mirror.


        :param display_name: The display_name of this MirrorSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def type(self):
        """
        Gets the type of this MirrorSummary.
        Type of software source.

        Allowed values for this property are: "CUSTOM", "VENDOR", "VERSIONED", "PRIVATE", "THIRD_PARTY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this MirrorSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this MirrorSummary.
        Type of software source.


        :param type: The type of this MirrorSummary.
        :type: str
        """
        allowed_values = ["CUSTOM", "VENDOR", "VERSIONED", "PRIVATE", "THIRD_PARTY"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def os_family(self):
        """
        Gets the os_family of this MirrorSummary.
        The OS family of the software source.

        Allowed values for this property are: "ORACLE_LINUX_9", "ORACLE_LINUX_8", "ORACLE_LINUX_7", "ORACLE_LINUX_6", "WINDOWS_SERVER_2016", "WINDOWS_SERVER_2019", "WINDOWS_SERVER_2022", "ALL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The os_family of this MirrorSummary.
        :rtype: str
        """
        return self._os_family

    @os_family.setter
    def os_family(self, os_family):
        """
        Sets the os_family of this MirrorSummary.
        The OS family of the software source.


        :param os_family: The os_family of this MirrorSummary.
        :type: str
        """
        allowed_values = ["ORACLE_LINUX_9", "ORACLE_LINUX_8", "ORACLE_LINUX_7", "ORACLE_LINUX_6", "WINDOWS_SERVER_2016", "WINDOWS_SERVER_2019", "WINDOWS_SERVER_2022", "ALL"]
        if not value_allowed_none_or_none_sentinel(os_family, allowed_values):
            os_family = 'UNKNOWN_ENUM_VALUE'
        self._os_family = os_family

    @property
    def arch_type(self):
        """
        Gets the arch_type of this MirrorSummary.
        The architecture type supported by the software source.

        Allowed values for this property are: "X86_64", "AARCH64", "I686", "NOARCH", "SRC", "I386", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The arch_type of this MirrorSummary.
        :rtype: str
        """
        return self._arch_type

    @arch_type.setter
    def arch_type(self, arch_type):
        """
        Sets the arch_type of this MirrorSummary.
        The architecture type supported by the software source.


        :param arch_type: The arch_type of this MirrorSummary.
        :type: str
        """
        allowed_values = ["X86_64", "AARCH64", "I686", "NOARCH", "SRC", "I386"]
        if not value_allowed_none_or_none_sentinel(arch_type, allowed_values):
            arch_type = 'UNKNOWN_ENUM_VALUE'
        self._arch_type = arch_type

    @property
    def state(self):
        """
        **[Required]** Gets the state of this MirrorSummary.
        Current state of the software source mirror.

        Allowed values for this property are: "UNSYNCED", "QUEUED", "SYNCING", "SYNCED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this MirrorSummary.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this MirrorSummary.
        Current state of the software source mirror.


        :param state: The state of this MirrorSummary.
        :type: str
        """
        allowed_values = ["UNSYNCED", "QUEUED", "SYNCING", "SYNCED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def percentage(self):
        """
        **[Required]** Gets the percentage of this MirrorSummary.
        A decimal number representing the percentage of the software source that has been synced.


        :return: The percentage of this MirrorSummary.
        :rtype: int
        """
        return self._percentage

    @percentage.setter
    def percentage(self, percentage):
        """
        Sets the percentage of this MirrorSummary.
        A decimal number representing the percentage of the software source that has been synced.


        :param percentage: The percentage of this MirrorSummary.
        :type: int
        """
        self._percentage = percentage

    @property
    def time_last_synced(self):
        """
        **[Required]** Gets the time_last_synced of this MirrorSummary.
        Time that the software source was last synced (in `RFC 3339`__ format).

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_last_synced of this MirrorSummary.
        :rtype: datetime
        """
        return self._time_last_synced

    @time_last_synced.setter
    def time_last_synced(self, time_last_synced):
        """
        Sets the time_last_synced of this MirrorSummary.
        Time that the software source was last synced (in `RFC 3339`__ format).

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_last_synced: The time_last_synced of this MirrorSummary.
        :type: datetime
        """
        self._time_last_synced = time_last_synced

    @property
    def log(self):
        """
        **[Required]** Gets the log of this MirrorSummary.
        The current log from the management station plugin.


        :return: The log of this MirrorSummary.
        :rtype: str
        """
        return self._log

    @log.setter
    def log(self, log):
        """
        Sets the log of this MirrorSummary.
        The current log from the management station plugin.


        :param log: The log of this MirrorSummary.
        :type: str
        """
        self._log = log

    @property
    def package_count(self):
        """
        **[Required]** Gets the package_count of this MirrorSummary.
        The number of packages within the mirrored software source.


        :return: The package_count of this MirrorSummary.
        :rtype: int
        """
        return self._package_count

    @package_count.setter
    def package_count(self, package_count):
        """
        Sets the package_count of this MirrorSummary.
        The number of packages within the mirrored software source.


        :param package_count: The package_count of this MirrorSummary.
        :type: int
        """
        self._package_count = package_count

    @property
    def size(self):
        """
        **[Required]** Gets the size of this MirrorSummary.
        The size the mirrored software source in bytes.


        :return: The size of this MirrorSummary.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """
        Sets the size of this MirrorSummary.
        The size the mirrored software source in bytes.


        :param size: The size of this MirrorSummary.
        :type: int
        """
        self._size = size

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
