# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901

from .event_content import EventContent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExploitAttemptEventContent(EventContent):
    """
    Provides information collected for the exploit attempt event.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExploitAttemptEventContent object with values from keyword arguments. The default value of the :py:attr:`~oci.os_management_hub.models.ExploitAttemptEventContent.type` attribute
        of this class is ``EXPLOIT_ATTEMPT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ExploitAttemptEventContent.
            Allowed values for this property are: "KERNEL", "EXPLOIT_ATTEMPT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param exploit_detection_log_content:
            The value to assign to the exploit_detection_log_content property of this ExploitAttemptEventContent.
        :type exploit_detection_log_content: str

        :param exploit_object_store_location:
            The value to assign to the exploit_object_store_location property of this ExploitAttemptEventContent.
        :type exploit_object_store_location: str

        """
        self.swagger_types = {
            'type': 'str',
            'exploit_detection_log_content': 'str',
            'exploit_object_store_location': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'exploit_detection_log_content': 'exploitDetectionLogContent',
            'exploit_object_store_location': 'exploitObjectStoreLocation'
        }
        self._type = None
        self._exploit_detection_log_content = None
        self._exploit_object_store_location = None
        self._type = 'EXPLOIT_ATTEMPT'

    @property
    def exploit_detection_log_content(self):
        """
        Gets the exploit_detection_log_content of this ExploitAttemptEventContent.
        The content of the exploit detection log.


        :return: The exploit_detection_log_content of this ExploitAttemptEventContent.
        :rtype: str
        """
        return self._exploit_detection_log_content

    @exploit_detection_log_content.setter
    def exploit_detection_log_content(self, exploit_detection_log_content):
        """
        Sets the exploit_detection_log_content of this ExploitAttemptEventContent.
        The content of the exploit detection log.


        :param exploit_detection_log_content: The exploit_detection_log_content of this ExploitAttemptEventContent.
        :type: str
        """
        self._exploit_detection_log_content = exploit_detection_log_content

    @property
    def exploit_object_store_location(self):
        """
        Gets the exploit_object_store_location of this ExploitAttemptEventContent.
        The location of the exploit detection log within object storage.


        :return: The exploit_object_store_location of this ExploitAttemptEventContent.
        :rtype: str
        """
        return self._exploit_object_store_location

    @exploit_object_store_location.setter
    def exploit_object_store_location(self, exploit_object_store_location):
        """
        Sets the exploit_object_store_location of this ExploitAttemptEventContent.
        The location of the exploit detection log within object storage.


        :param exploit_object_store_location: The exploit_object_store_location of this ExploitAttemptEventContent.
        :type: str
        """
        self._exploit_object_store_location = exploit_object_store_location

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
