# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExploitAttemptAdditionalDetails(object):
    """
    Provides additional information about the Ksplice known exploit detection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExploitAttemptAdditionalDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param exploit_cves:
            The value to assign to the exploit_cves property of this ExploitAttemptAdditionalDetails.
        :type exploit_cves: list[str]

        """
        self.swagger_types = {
            'exploit_cves': 'list[str]'
        }
        self.attribute_map = {
            'exploit_cves': 'exploitCves'
        }
        self._exploit_cves = None

    @property
    def exploit_cves(self):
        """
        **[Required]** Gets the exploit_cves of this ExploitAttemptAdditionalDetails.
        List of CVEs in the exploit.


        :return: The exploit_cves of this ExploitAttemptAdditionalDetails.
        :rtype: list[str]
        """
        return self._exploit_cves

    @exploit_cves.setter
    def exploit_cves(self, exploit_cves):
        """
        Sets the exploit_cves of this ExploitAttemptAdditionalDetails.
        List of CVEs in the exploit.


        :param exploit_cves: The exploit_cves of this ExploitAttemptAdditionalDetails.
        :type: list[str]
        """
        self._exploit_cves = exploit_cves

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
