# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .exadata_configuration_summary import ExadataConfigurationSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadataDatabaseMachineConfigurationSummary(ExadataConfigurationSummary):
    """
    Configuration summary of a database machine.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExadataDatabaseMachineConfigurationSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.ExadataDatabaseMachineConfigurationSummary.entity_source` attribute
        of this class is ``EM_MANAGED_EXTERNAL_EXADATA`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param exadata_insight_id:
            The value to assign to the exadata_insight_id property of this ExadataDatabaseMachineConfigurationSummary.
        :type exadata_insight_id: str

        :param entity_source:
            The value to assign to the entity_source property of this ExadataDatabaseMachineConfigurationSummary.
            Allowed values for this property are: "EM_MANAGED_EXTERNAL_EXADATA", "PE_COMANAGED_EXADATA", "MACS_MANAGED_CLOUD_EXADATA"
        :type entity_source: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ExadataDatabaseMachineConfigurationSummary.
        :type compartment_id: str

        :param exadata_name:
            The value to assign to the exadata_name property of this ExadataDatabaseMachineConfigurationSummary.
        :type exadata_name: str

        :param exadata_display_name:
            The value to assign to the exadata_display_name property of this ExadataDatabaseMachineConfigurationSummary.
        :type exadata_display_name: str

        :param exadata_type:
            The value to assign to the exadata_type property of this ExadataDatabaseMachineConfigurationSummary.
            Allowed values for this property are: "DBMACHINE", "EXACS", "EXACC"
        :type exadata_type: str

        :param exadata_rack_type:
            The value to assign to the exadata_rack_type property of this ExadataDatabaseMachineConfigurationSummary.
            Allowed values for this property are: "FULL", "HALF", "QUARTER", "EIGHTH", "FLEX", "BASE", "ELASTIC", "ELASTIC_BASE", "ELASTIC_LARGE", "ELASTIC_EXTRA_LARGE"
        :type exadata_rack_type: str

        :param defined_tags:
            The value to assign to the defined_tags property of this ExadataDatabaseMachineConfigurationSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ExadataDatabaseMachineConfigurationSummary.
        :type freeform_tags: dict(str, str)

        :param vmcluster_details:
            The value to assign to the vmcluster_details property of this ExadataDatabaseMachineConfigurationSummary.
        :type vmcluster_details: list[oci.opsi.models.VmClusterSummary]

        :param enterprise_manager_identifier:
            The value to assign to the enterprise_manager_identifier property of this ExadataDatabaseMachineConfigurationSummary.
        :type enterprise_manager_identifier: str

        :param enterprise_manager_bridge_id:
            The value to assign to the enterprise_manager_bridge_id property of this ExadataDatabaseMachineConfigurationSummary.
        :type enterprise_manager_bridge_id: str

        :param enterprise_manager_entity_identifier:
            The value to assign to the enterprise_manager_entity_identifier property of this ExadataDatabaseMachineConfigurationSummary.
        :type enterprise_manager_entity_identifier: str

        :param enterprise_manager_console_url:
            The value to assign to the enterprise_manager_console_url property of this ExadataDatabaseMachineConfigurationSummary.
        :type enterprise_manager_console_url: str

        :param enterprise_manager_oms_ver:
            The value to assign to the enterprise_manager_oms_ver property of this ExadataDatabaseMachineConfigurationSummary.
        :type enterprise_manager_oms_ver: str

        :param enterprise_manager_entity_type:
            The value to assign to the enterprise_manager_entity_type property of this ExadataDatabaseMachineConfigurationSummary.
        :type enterprise_manager_entity_type: str

        :param parent_id:
            The value to assign to the parent_id property of this ExadataDatabaseMachineConfigurationSummary.
        :type parent_id: str

        :param region:
            The value to assign to the region property of this ExadataDatabaseMachineConfigurationSummary.
        :type region: str

        """
        self.swagger_types = {
            'exadata_insight_id': 'str',
            'entity_source': 'str',
            'compartment_id': 'str',
            'exadata_name': 'str',
            'exadata_display_name': 'str',
            'exadata_type': 'str',
            'exadata_rack_type': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'vmcluster_details': 'list[VmClusterSummary]',
            'enterprise_manager_identifier': 'str',
            'enterprise_manager_bridge_id': 'str',
            'enterprise_manager_entity_identifier': 'str',
            'enterprise_manager_console_url': 'str',
            'enterprise_manager_oms_ver': 'str',
            'enterprise_manager_entity_type': 'str',
            'parent_id': 'str',
            'region': 'str'
        }
        self.attribute_map = {
            'exadata_insight_id': 'exadataInsightId',
            'entity_source': 'entitySource',
            'compartment_id': 'compartmentId',
            'exadata_name': 'exadataName',
            'exadata_display_name': 'exadataDisplayName',
            'exadata_type': 'exadataType',
            'exadata_rack_type': 'exadataRackType',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'vmcluster_details': 'vmclusterDetails',
            'enterprise_manager_identifier': 'enterpriseManagerIdentifier',
            'enterprise_manager_bridge_id': 'enterpriseManagerBridgeId',
            'enterprise_manager_entity_identifier': 'enterpriseManagerEntityIdentifier',
            'enterprise_manager_console_url': 'enterpriseManagerConsoleUrl',
            'enterprise_manager_oms_ver': 'enterpriseManagerOmsVer',
            'enterprise_manager_entity_type': 'enterpriseManagerEntityType',
            'parent_id': 'parentId',
            'region': 'region'
        }
        self._exadata_insight_id = None
        self._entity_source = None
        self._compartment_id = None
        self._exadata_name = None
        self._exadata_display_name = None
        self._exadata_type = None
        self._exadata_rack_type = None
        self._defined_tags = None
        self._freeform_tags = None
        self._vmcluster_details = None
        self._enterprise_manager_identifier = None
        self._enterprise_manager_bridge_id = None
        self._enterprise_manager_entity_identifier = None
        self._enterprise_manager_console_url = None
        self._enterprise_manager_oms_ver = None
        self._enterprise_manager_entity_type = None
        self._parent_id = None
        self._region = None
        self._entity_source = 'EM_MANAGED_EXTERNAL_EXADATA'

    @property
    def enterprise_manager_identifier(self):
        """
        **[Required]** Gets the enterprise_manager_identifier of this ExadataDatabaseMachineConfigurationSummary.
        Enterprise Manager Unique Identifier


        :return: The enterprise_manager_identifier of this ExadataDatabaseMachineConfigurationSummary.
        :rtype: str
        """
        return self._enterprise_manager_identifier

    @enterprise_manager_identifier.setter
    def enterprise_manager_identifier(self, enterprise_manager_identifier):
        """
        Sets the enterprise_manager_identifier of this ExadataDatabaseMachineConfigurationSummary.
        Enterprise Manager Unique Identifier


        :param enterprise_manager_identifier: The enterprise_manager_identifier of this ExadataDatabaseMachineConfigurationSummary.
        :type: str
        """
        self._enterprise_manager_identifier = enterprise_manager_identifier

    @property
    def enterprise_manager_bridge_id(self):
        """
        **[Required]** Gets the enterprise_manager_bridge_id of this ExadataDatabaseMachineConfigurationSummary.
        OPSI Enterprise Manager Bridge OCID


        :return: The enterprise_manager_bridge_id of this ExadataDatabaseMachineConfigurationSummary.
        :rtype: str
        """
        return self._enterprise_manager_bridge_id

    @enterprise_manager_bridge_id.setter
    def enterprise_manager_bridge_id(self, enterprise_manager_bridge_id):
        """
        Sets the enterprise_manager_bridge_id of this ExadataDatabaseMachineConfigurationSummary.
        OPSI Enterprise Manager Bridge OCID


        :param enterprise_manager_bridge_id: The enterprise_manager_bridge_id of this ExadataDatabaseMachineConfigurationSummary.
        :type: str
        """
        self._enterprise_manager_bridge_id = enterprise_manager_bridge_id

    @property
    def enterprise_manager_entity_identifier(self):
        """
        **[Required]** Gets the enterprise_manager_entity_identifier of this ExadataDatabaseMachineConfigurationSummary.
        Enterprise Manager Entity Unique Identifier


        :return: The enterprise_manager_entity_identifier of this ExadataDatabaseMachineConfigurationSummary.
        :rtype: str
        """
        return self._enterprise_manager_entity_identifier

    @enterprise_manager_entity_identifier.setter
    def enterprise_manager_entity_identifier(self, enterprise_manager_entity_identifier):
        """
        Sets the enterprise_manager_entity_identifier of this ExadataDatabaseMachineConfigurationSummary.
        Enterprise Manager Entity Unique Identifier


        :param enterprise_manager_entity_identifier: The enterprise_manager_entity_identifier of this ExadataDatabaseMachineConfigurationSummary.
        :type: str
        """
        self._enterprise_manager_entity_identifier = enterprise_manager_entity_identifier

    @property
    def enterprise_manager_console_url(self):
        """
        **[Required]** Gets the enterprise_manager_console_url of this ExadataDatabaseMachineConfigurationSummary.
        Enterprise Manager Console Url


        :return: The enterprise_manager_console_url of this ExadataDatabaseMachineConfigurationSummary.
        :rtype: str
        """
        return self._enterprise_manager_console_url

    @enterprise_manager_console_url.setter
    def enterprise_manager_console_url(self, enterprise_manager_console_url):
        """
        Sets the enterprise_manager_console_url of this ExadataDatabaseMachineConfigurationSummary.
        Enterprise Manager Console Url


        :param enterprise_manager_console_url: The enterprise_manager_console_url of this ExadataDatabaseMachineConfigurationSummary.
        :type: str
        """
        self._enterprise_manager_console_url = enterprise_manager_console_url

    @property
    def enterprise_manager_oms_ver(self):
        """
        **[Required]** Gets the enterprise_manager_oms_ver of this ExadataDatabaseMachineConfigurationSummary.
        Enterprise Manager OMS Version


        :return: The enterprise_manager_oms_ver of this ExadataDatabaseMachineConfigurationSummary.
        :rtype: str
        """
        return self._enterprise_manager_oms_ver

    @enterprise_manager_oms_ver.setter
    def enterprise_manager_oms_ver(self, enterprise_manager_oms_ver):
        """
        Sets the enterprise_manager_oms_ver of this ExadataDatabaseMachineConfigurationSummary.
        Enterprise Manager OMS Version


        :param enterprise_manager_oms_ver: The enterprise_manager_oms_ver of this ExadataDatabaseMachineConfigurationSummary.
        :type: str
        """
        self._enterprise_manager_oms_ver = enterprise_manager_oms_ver

    @property
    def enterprise_manager_entity_type(self):
        """
        **[Required]** Gets the enterprise_manager_entity_type of this ExadataDatabaseMachineConfigurationSummary.
        Enterprise Manager Entity Type


        :return: The enterprise_manager_entity_type of this ExadataDatabaseMachineConfigurationSummary.
        :rtype: str
        """
        return self._enterprise_manager_entity_type

    @enterprise_manager_entity_type.setter
    def enterprise_manager_entity_type(self, enterprise_manager_entity_type):
        """
        Sets the enterprise_manager_entity_type of this ExadataDatabaseMachineConfigurationSummary.
        Enterprise Manager Entity Type


        :param enterprise_manager_entity_type: The enterprise_manager_entity_type of this ExadataDatabaseMachineConfigurationSummary.
        :type: str
        """
        self._enterprise_manager_entity_type = enterprise_manager_entity_type

    @property
    def parent_id(self):
        """
        Gets the parent_id of this ExadataDatabaseMachineConfigurationSummary.
        The `OCID`__ of the database.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The parent_id of this ExadataDatabaseMachineConfigurationSummary.
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """
        Sets the parent_id of this ExadataDatabaseMachineConfigurationSummary.
        The `OCID`__ of the database.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param parent_id: The parent_id of this ExadataDatabaseMachineConfigurationSummary.
        :type: str
        """
        self._parent_id = parent_id

    @property
    def region(self):
        """
        Gets the region of this ExadataDatabaseMachineConfigurationSummary.
        The region the resource resides in.


        :return: The region of this ExadataDatabaseMachineConfigurationSummary.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this ExadataDatabaseMachineConfigurationSummary.
        The region the resource resides in.


        :param region: The region of this ExadataDatabaseMachineConfigurationSummary.
        :type: str
        """
        self._region = region

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
