# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OutboundClusterConfig(object):
    """
    This configuration is used for passing request details to connect outbound cluster(s) to the inbound cluster (coordinating cluster)
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OutboundClusterConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_enabled:
            The value to assign to the is_enabled property of this OutboundClusterConfig.
        :type is_enabled: bool

        :param outbound_clusters:
            The value to assign to the outbound_clusters property of this OutboundClusterConfig.
        :type outbound_clusters: list[oci.opensearch.models.OutboundClusterSummary]

        """
        self.swagger_types = {
            'is_enabled': 'bool',
            'outbound_clusters': 'list[OutboundClusterSummary]'
        }
        self.attribute_map = {
            'is_enabled': 'isEnabled',
            'outbound_clusters': 'outboundClusters'
        }
        self._is_enabled = None
        self._outbound_clusters = None

    @property
    def is_enabled(self):
        """
        **[Required]** Gets the is_enabled of this OutboundClusterConfig.
        Flag to indicate whether outbound cluster configuration is enabled


        :return: The is_enabled of this OutboundClusterConfig.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this OutboundClusterConfig.
        Flag to indicate whether outbound cluster configuration is enabled


        :param is_enabled: The is_enabled of this OutboundClusterConfig.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def outbound_clusters(self):
        """
        **[Required]** Gets the outbound_clusters of this OutboundClusterConfig.
        List of outbound clusters to be connected to the inbound cluster


        :return: The outbound_clusters of this OutboundClusterConfig.
        :rtype: list[oci.opensearch.models.OutboundClusterSummary]
        """
        return self._outbound_clusters

    @outbound_clusters.setter
    def outbound_clusters(self, outbound_clusters):
        """
        Sets the outbound_clusters of this OutboundClusterConfig.
        List of outbound clusters to be connected to the inbound cluster


        :param outbound_clusters: The outbound_clusters of this OutboundClusterConfig.
        :type: list[oci.opensearch.models.OutboundClusterSummary]
        """
        self._outbound_clusters = outbound_clusters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
