# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagementAppliance(object):
    """
    Information about management appliance.
    """

    #: A constant which can be used with the lifecycle_state property of a ManagementAppliance.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ManagementAppliance.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ManagementAppliance.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ManagementAppliance.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a ManagementAppliance.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ManagementAppliance.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ManagementAppliance.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_details property of a ManagementAppliance.
    #: This constant has a value of "HEALTHY"
    LIFECYCLE_DETAILS_HEALTHY = "HEALTHY"

    #: A constant which can be used with the lifecycle_details property of a ManagementAppliance.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_DETAILS_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_details property of a ManagementAppliance.
    #: This constant has a value of "DELETING"
    LIFECYCLE_DETAILS_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_details property of a ManagementAppliance.
    #: This constant has a value of "DELETED"
    LIFECYCLE_DETAILS_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_details property of a ManagementAppliance.
    #: This constant has a value of "FAILED"
    LIFECYCLE_DETAILS_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_details property of a ManagementAppliance.
    #: This constant has a value of "CREATING"
    LIFECYCLE_DETAILS_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_details property of a ManagementAppliance.
    #: This constant has a value of "WAITING_FOR_HEARTBEAT"
    LIFECYCLE_DETAILS_WAITING_FOR_HEARTBEAT = "WAITING_FOR_HEARTBEAT"

    #: A constant which can be used with the lifecycle_details property of a ManagementAppliance.
    #: This constant has a value of "HEARTBEAT_TIMEOUT"
    LIFECYCLE_DETAILS_HEARTBEAT_TIMEOUT = "HEARTBEAT_TIMEOUT"

    #: A constant which can be used with the lifecycle_details property of a ManagementAppliance.
    #: This constant has a value of "CAN_NOT_CONNECT_TO_VCENTER"
    LIFECYCLE_DETAILS_CAN_NOT_CONNECT_TO_VCENTER = "CAN_NOT_CONNECT_TO_VCENTER"

    #: A constant which can be used with the lifecycle_details property of a ManagementAppliance.
    #: This constant has a value of "UI_PLUGIN_IS_NOT_REGISTERED"
    LIFECYCLE_DETAILS_UI_PLUGIN_IS_NOT_REGISTERED = "UI_PLUGIN_IS_NOT_REGISTERED"

    #: A constant which can be used with the lifecycle_details property of a ManagementAppliance.
    #: This constant has a value of "UNKNOWN_DETAILS"
    LIFECYCLE_DETAILS_UNKNOWN_DETAILS = "UNKNOWN_DETAILS"

    def __init__(self, **kwargs):
        """
        Initializes a new ManagementAppliance object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ManagementAppliance.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ManagementAppliance.
        :type compartment_id: str

        :param sddc_id:
            The value to assign to the sddc_id property of this ManagementAppliance.
        :type sddc_id: str

        :param compute_instance_id:
            The value to assign to the compute_instance_id property of this ManagementAppliance.
        :type compute_instance_id: str

        :param management_agent_id:
            The value to assign to the management_agent_id property of this ManagementAppliance.
        :type management_agent_id: str

        :param display_name:
            The value to assign to the display_name property of this ManagementAppliance.
        :type display_name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ManagementAppliance.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ManagementAppliance.
            Allowed values for this property are: "HEALTHY", "UPDATING", "DELETING", "DELETED", "FAILED", "CREATING", "WAITING_FOR_HEARTBEAT", "HEARTBEAT_TIMEOUT", "CAN_NOT_CONNECT_TO_VCENTER", "UI_PLUGIN_IS_NOT_REGISTERED", "UNKNOWN_DETAILS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_details: str

        :param configuration:
            The value to assign to the configuration property of this ManagementAppliance.
        :type configuration: oci.ocvp.models.ManagementApplianceConfiguration

        :param connections:
            The value to assign to the connections property of this ManagementAppliance.
        :type connections: list[oci.ocvp.models.ManagementApplianceConnection]

        :param time_created:
            The value to assign to the time_created property of this ManagementAppliance.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ManagementAppliance.
        :type time_updated: datetime

        :param time_configuration_updated:
            The value to assign to the time_configuration_updated property of this ManagementAppliance.
        :type time_configuration_updated: datetime

        :param time_last_heartbeat:
            The value to assign to the time_last_heartbeat property of this ManagementAppliance.
        :type time_last_heartbeat: datetime

        :param heartbeat_connection_states:
            The value to assign to the heartbeat_connection_states property of this ManagementAppliance.
        :type heartbeat_connection_states: list[oci.ocvp.models.ManagementApplianceConnectionStatus]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ManagementAppliance.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ManagementAppliance.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ManagementAppliance.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'sddc_id': 'str',
            'compute_instance_id': 'str',
            'management_agent_id': 'str',
            'display_name': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'configuration': 'ManagementApplianceConfiguration',
            'connections': 'list[ManagementApplianceConnection]',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_configuration_updated': 'datetime',
            'time_last_heartbeat': 'datetime',
            'heartbeat_connection_states': 'list[ManagementApplianceConnectionStatus]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'sddc_id': 'sddcId',
            'compute_instance_id': 'computeInstanceId',
            'management_agent_id': 'managementAgentId',
            'display_name': 'displayName',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'configuration': 'configuration',
            'connections': 'connections',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_configuration_updated': 'timeConfigurationUpdated',
            'time_last_heartbeat': 'timeLastHeartbeat',
            'heartbeat_connection_states': 'heartbeatConnectionStates',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._sddc_id = None
        self._compute_instance_id = None
        self._management_agent_id = None
        self._display_name = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._configuration = None
        self._connections = None
        self._time_created = None
        self._time_updated = None
        self._time_configuration_updated = None
        self._time_last_heartbeat = None
        self._heartbeat_connection_states = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ManagementAppliance.
        The `OCID`__ of management appliance.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this ManagementAppliance.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ManagementAppliance.
        The `OCID`__ of management appliance.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this ManagementAppliance.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ManagementAppliance.
        The `OCID`__ of compartment in OCI, that this appliance is going to be created in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ManagementAppliance.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ManagementAppliance.
        The `OCID`__ of compartment in OCI, that this appliance is going to be created in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ManagementAppliance.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def sddc_id(self):
        """
        **[Required]** Gets the sddc_id of this ManagementAppliance.
        The `OCID`__ of SDDC in OCI, that this appliance is going to be registered in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The sddc_id of this ManagementAppliance.
        :rtype: str
        """
        return self._sddc_id

    @sddc_id.setter
    def sddc_id(self, sddc_id):
        """
        Sets the sddc_id of this ManagementAppliance.
        The `OCID`__ of SDDC in OCI, that this appliance is going to be registered in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param sddc_id: The sddc_id of this ManagementAppliance.
        :type: str
        """
        self._sddc_id = sddc_id

    @property
    def compute_instance_id(self):
        """
        Gets the compute_instance_id of this ManagementAppliance.
        The `OCID`__ of compute instance of management appliance in OCI.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compute_instance_id of this ManagementAppliance.
        :rtype: str
        """
        return self._compute_instance_id

    @compute_instance_id.setter
    def compute_instance_id(self, compute_instance_id):
        """
        Sets the compute_instance_id of this ManagementAppliance.
        The `OCID`__ of compute instance of management appliance in OCI.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compute_instance_id: The compute_instance_id of this ManagementAppliance.
        :type: str
        """
        self._compute_instance_id = compute_instance_id

    @property
    def management_agent_id(self):
        """
        Gets the management_agent_id of this ManagementAppliance.
        The `OCID`__ of management agent, that this appliance is running in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The management_agent_id of this ManagementAppliance.
        :rtype: str
        """
        return self._management_agent_id

    @management_agent_id.setter
    def management_agent_id(self, management_agent_id):
        """
        Sets the management_agent_id of this ManagementAppliance.
        The `OCID`__ of management agent, that this appliance is running in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param management_agent_id: The management_agent_id of this ManagementAppliance.
        :type: str
        """
        self._management_agent_id = management_agent_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ManagementAppliance.
        A descriptive name for the management appliance. It must be unique, start with a letter, and contain only letters, digits, whitespaces, dashes and underscores. Avoid entering confidential information.


        :return: The display_name of this ManagementAppliance.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ManagementAppliance.
        A descriptive name for the management appliance. It must be unique, start with a letter, and contain only letters, digits, whitespaces, dashes and underscores. Avoid entering confidential information.


        :param display_name: The display_name of this ManagementAppliance.
        :type: str
        """
        self._display_name = display_name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ManagementAppliance.
        Current state of the management appliance.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ManagementAppliance.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ManagementAppliance.
        Current state of the management appliance.


        :param lifecycle_state: The lifecycle_state of this ManagementAppliance.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ManagementAppliance.
        Information about current lifecycleState. For FAILED and NEEDS_ATTENTION contains explanations. For other states may contain some details about their progress.

        Allowed values for this property are: "HEALTHY", "UPDATING", "DELETING", "DELETED", "FAILED", "CREATING", "WAITING_FOR_HEARTBEAT", "HEARTBEAT_TIMEOUT", "CAN_NOT_CONNECT_TO_VCENTER", "UI_PLUGIN_IS_NOT_REGISTERED", "UNKNOWN_DETAILS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_details of this ManagementAppliance.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ManagementAppliance.
        Information about current lifecycleState. For FAILED and NEEDS_ATTENTION contains explanations. For other states may contain some details about their progress.


        :param lifecycle_details: The lifecycle_details of this ManagementAppliance.
        :type: str
        """
        allowed_values = ["HEALTHY", "UPDATING", "DELETING", "DELETED", "FAILED", "CREATING", "WAITING_FOR_HEARTBEAT", "HEARTBEAT_TIMEOUT", "CAN_NOT_CONNECT_TO_VCENTER", "UI_PLUGIN_IS_NOT_REGISTERED", "UNKNOWN_DETAILS"]
        if not value_allowed_none_or_none_sentinel(lifecycle_details, allowed_values):
            lifecycle_details = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_details = lifecycle_details

    @property
    def configuration(self):
        """
        **[Required]** Gets the configuration of this ManagementAppliance.

        :return: The configuration of this ManagementAppliance.
        :rtype: oci.ocvp.models.ManagementApplianceConfiguration
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """
        Sets the configuration of this ManagementAppliance.

        :param configuration: The configuration of this ManagementAppliance.
        :type: oci.ocvp.models.ManagementApplianceConfiguration
        """
        self._configuration = configuration

    @property
    def connections(self):
        """
        **[Required]** Gets the connections of this ManagementAppliance.
        Array of connections for management appliance.


        :return: The connections of this ManagementAppliance.
        :rtype: list[oci.ocvp.models.ManagementApplianceConnection]
        """
        return self._connections

    @connections.setter
    def connections(self, connections):
        """
        Sets the connections of this ManagementAppliance.
        Array of connections for management appliance.


        :param connections: The connections of this ManagementAppliance.
        :type: list[oci.ocvp.models.ManagementApplianceConnection]
        """
        self._connections = connections

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ManagementAppliance.
        The date and time the management appliance was created in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ManagementAppliance.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ManagementAppliance.
        The date and time the management appliance was created in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ManagementAppliance.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this ManagementAppliance.
        The date and time the management appliance was last updated in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ManagementAppliance.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ManagementAppliance.
        The date and time the management appliance was last updated in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ManagementAppliance.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_configuration_updated(self):
        """
        Gets the time_configuration_updated of this ManagementAppliance.
        The date and time the configuration of management appliance was last updated in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_configuration_updated of this ManagementAppliance.
        :rtype: datetime
        """
        return self._time_configuration_updated

    @time_configuration_updated.setter
    def time_configuration_updated(self, time_configuration_updated):
        """
        Sets the time_configuration_updated of this ManagementAppliance.
        The date and time the configuration of management appliance was last updated in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_configuration_updated: The time_configuration_updated of this ManagementAppliance.
        :type: datetime
        """
        self._time_configuration_updated = time_configuration_updated

    @property
    def time_last_heartbeat(self):
        """
        Gets the time_last_heartbeat of this ManagementAppliance.
        The date and time the management appliance has last received heartbeat in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_last_heartbeat of this ManagementAppliance.
        :rtype: datetime
        """
        return self._time_last_heartbeat

    @time_last_heartbeat.setter
    def time_last_heartbeat(self, time_last_heartbeat):
        """
        Sets the time_last_heartbeat of this ManagementAppliance.
        The date and time the management appliance has last received heartbeat in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_last_heartbeat: The time_last_heartbeat of this ManagementAppliance.
        :type: datetime
        """
        self._time_last_heartbeat = time_last_heartbeat

    @property
    def heartbeat_connection_states(self):
        """
        Gets the heartbeat_connection_states of this ManagementAppliance.
        Current states of connections.


        :return: The heartbeat_connection_states of this ManagementAppliance.
        :rtype: list[oci.ocvp.models.ManagementApplianceConnectionStatus]
        """
        return self._heartbeat_connection_states

    @heartbeat_connection_states.setter
    def heartbeat_connection_states(self, heartbeat_connection_states):
        """
        Sets the heartbeat_connection_states of this ManagementAppliance.
        Current states of connections.


        :param heartbeat_connection_states: The heartbeat_connection_states of this ManagementAppliance.
        :type: list[oci.ocvp.models.ManagementApplianceConnectionStatus]
        """
        self._heartbeat_connection_states = heartbeat_connection_states

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ManagementAppliance.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ManagementAppliance.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ManagementAppliance.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ManagementAppliance.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ManagementAppliance.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ManagementAppliance.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ManagementAppliance.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ManagementAppliance.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ManagementAppliance.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{orcl-cloud: {free-tier-retain: true}}`


        :return: The system_tags of this ManagementAppliance.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ManagementAppliance.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{orcl-cloud: {free-tier-retain: true}}`


        :param system_tags: The system_tags of this ManagementAppliance.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
