# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DeletedObjectResult(object):
    """
    Delete object details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DeletedObjectResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param object_name:
            The value to assign to the object_name property of this DeletedObjectResult.
        :type object_name: str

        :param time_last_modified:
            The value to assign to the time_last_modified property of this DeletedObjectResult.
        :type time_last_modified: datetime

        """
        self.swagger_types = {
            'object_name': 'str',
            'time_last_modified': 'datetime'
        }
        self.attribute_map = {
            'object_name': 'objectName',
            'time_last_modified': 'timeLastModified'
        }
        self._object_name = None
        self._time_last_modified = None

    @property
    def object_name(self):
        """
        **[Required]** Gets the object_name of this DeletedObjectResult.
        The name of the deleted object. Avoid entering confidential information.
        Example: test/object1.log


        :return: The object_name of this DeletedObjectResult.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this DeletedObjectResult.
        The name of the deleted object. Avoid entering confidential information.
        Example: test/object1.log


        :param object_name: The object_name of this DeletedObjectResult.
        :type: str
        """
        self._object_name = object_name

    @property
    def time_last_modified(self):
        """
        **[Required]** Gets the time_last_modified of this DeletedObjectResult.
        The time the object was deleted, as described in `RFC 2616`__.

        __ https://tools.ietf.org/html/rfc2616#section-14.29


        :return: The time_last_modified of this DeletedObjectResult.
        :rtype: datetime
        """
        return self._time_last_modified

    @time_last_modified.setter
    def time_last_modified(self, time_last_modified):
        """
        Sets the time_last_modified of this DeletedObjectResult.
        The time the object was deleted, as described in `RFC 2616`__.

        __ https://tools.ietf.org/html/rfc2616#section-14.29


        :param time_last_modified: The time_last_modified of this DeletedObjectResult.
        :type: datetime
        """
        self._time_last_modified = time_last_modified

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
