# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UrlListSummary(object):
    """
    URL List Summary in the network firewall policy
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UrlListSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this UrlListSummary.
        :type name: str

        :param total_urls:
            The value to assign to the total_urls property of this UrlListSummary.
        :type total_urls: int

        :param parent_resource_id:
            The value to assign to the parent_resource_id property of this UrlListSummary.
        :type parent_resource_id: str

        :param description:
            The value to assign to the description property of this UrlListSummary.
        :type description: str

        """
        self.swagger_types = {
            'name': 'str',
            'total_urls': 'int',
            'parent_resource_id': 'str',
            'description': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'total_urls': 'totalUrls',
            'parent_resource_id': 'parentResourceId',
            'description': 'description'
        }
        self._name = None
        self._total_urls = None
        self._parent_resource_id = None
        self._description = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this UrlListSummary.
        Name of URL List


        :return: The name of this UrlListSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UrlListSummary.
        Name of URL List


        :param name: The name of this UrlListSummary.
        :type: str
        """
        self._name = name

    @property
    def total_urls(self):
        """
        **[Required]** Gets the total_urls of this UrlListSummary.
        Total count of URLs in the URL List


        :return: The total_urls of this UrlListSummary.
        :rtype: int
        """
        return self._total_urls

    @total_urls.setter
    def total_urls(self, total_urls):
        """
        Sets the total_urls of this UrlListSummary.
        Total count of URLs in the URL List


        :param total_urls: The total_urls of this UrlListSummary.
        :type: int
        """
        self._total_urls = total_urls

    @property
    def parent_resource_id(self):
        """
        **[Required]** Gets the parent_resource_id of this UrlListSummary.
        OCID of the Network Firewall Policy this mapped secret belongs to.


        :return: The parent_resource_id of this UrlListSummary.
        :rtype: str
        """
        return self._parent_resource_id

    @parent_resource_id.setter
    def parent_resource_id(self, parent_resource_id):
        """
        Sets the parent_resource_id of this UrlListSummary.
        OCID of the Network Firewall Policy this mapped secret belongs to.


        :param parent_resource_id: The parent_resource_id of this UrlListSummary.
        :type: str
        """
        self._parent_resource_id = parent_resource_id

    @property
    def description(self):
        """
        Gets the description of this UrlListSummary.
        The description of the Url list. This field can be used to add additional info.


        :return: The description of this UrlListSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UrlListSummary.
        The description of the Url list. This field can be used to add additional info.


        :param description: The description of this UrlListSummary.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
