# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateNatRuleDetails(object):
    """
    Request for creating a NAT rule used in the firewall policy.
    A `NAT rule`__ defines which traffic NAT should be applied to by the firewall.

    __ https://docs.cloud.oracle.com/iaas/Content/network-firewall/policies.htm#network-firewall-policies__nat
    """

    #: A constant which can be used with the type property of a CreateNatRuleDetails.
    #: This constant has a value of "NATV4"
    TYPE_NATV4 = "NATV4"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateNatRuleDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.network_firewall.models.CreateNatV4RuleDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateNatRuleDetails.
        :type name: str

        :param type:
            The value to assign to the type property of this CreateNatRuleDetails.
            Allowed values for this property are: "NATV4"
        :type type: str

        :param description:
            The value to assign to the description property of this CreateNatRuleDetails.
        :type description: str

        :param position:
            The value to assign to the position property of this CreateNatRuleDetails.
        :type position: oci.network_firewall.models.RulePosition

        """
        self.swagger_types = {
            'name': 'str',
            'type': 'str',
            'description': 'str',
            'position': 'RulePosition'
        }
        self.attribute_map = {
            'name': 'name',
            'type': 'type',
            'description': 'description',
            'position': 'position'
        }
        self._name = None
        self._type = None
        self._description = None
        self._position = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'NATV4':
            return 'CreateNatV4RuleDetails'
        else:
            return 'CreateNatRuleDetails'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateNatRuleDetails.
        Name for the NAT rule, must be unique within the policy.


        :return: The name of this CreateNatRuleDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateNatRuleDetails.
        Name for the NAT rule, must be unique within the policy.


        :param name: The name of this CreateNatRuleDetails.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateNatRuleDetails.
        NAT type:

        * NATV4 - NATV4 type NAT.

        Allowed values for this property are: "NATV4"


        :return: The type of this CreateNatRuleDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateNatRuleDetails.
        NAT type:

        * NATV4 - NATV4 type NAT.


        :param type: The type of this CreateNatRuleDetails.
        :type: str
        """
        allowed_values = ["NATV4"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def description(self):
        """
        Gets the description of this CreateNatRuleDetails.
        Description of a NAT rule. This field can be used to add additional info.


        :return: The description of this CreateNatRuleDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateNatRuleDetails.
        Description of a NAT rule. This field can be used to add additional info.


        :param description: The description of this CreateNatRuleDetails.
        :type: str
        """
        self._description = description

    @property
    def position(self):
        """
        Gets the position of this CreateNatRuleDetails.

        :return: The position of this CreateNatRuleDetails.
        :rtype: oci.network_firewall.models.RulePosition
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this CreateNatRuleDetails.

        :param position: The position of this CreateNatRuleDetails.
        :type: oci.network_firewall.models.RulePosition
        """
        self._position = position

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
