# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TelemetryConfigurationDetails(object):
    """
    Telemetry configuration details of a DB System or a read replica.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TelemetryConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param logs:
            The value to assign to the logs property of this TelemetryConfigurationDetails.
        :type logs: list[oci.mysql.models.LoggingDestinationConfiguration]

        """
        self.swagger_types = {
            'logs': 'list[LoggingDestinationConfiguration]'
        }
        self.attribute_map = {
            'logs': 'logs'
        }
        self._logs = None

    @property
    def logs(self):
        """
        Gets the logs of this TelemetryConfigurationDetails.
        Telemetry configuration details for logging.


        :return: The logs of this TelemetryConfigurationDetails.
        :rtype: list[oci.mysql.models.LoggingDestinationConfiguration]
        """
        return self._logs

    @logs.setter
    def logs(self, logs):
        """
        Sets the logs of this TelemetryConfigurationDetails.
        Telemetry configuration details for logging.


        :param logs: The logs of this TelemetryConfigurationDetails.
        :type: list[oci.mysql.models.LoggingDestinationConfiguration]
        """
        self._logs = logs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
