# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaintenanceEvent(object):
    """
    The details of a maintenance event.
    """

    #: A constant which can be used with the maintenance_scope property of a MaintenanceEvent.
    #: This constant has a value of "ALL"
    MAINTENANCE_SCOPE_ALL = "ALL"

    #: A constant which can be used with the maintenance_scope property of a MaintenanceEvent.
    #: This constant has a value of "ALL_BUT_PRIMARY"
    MAINTENANCE_SCOPE_ALL_BUT_PRIMARY = "ALL_BUT_PRIMARY"

    #: A constant which can be used with the maintenance_scope property of a MaintenanceEvent.
    #: This constant has a value of "PRIMARY_ONLY"
    MAINTENANCE_SCOPE_PRIMARY_ONLY = "PRIMARY_ONLY"

    #: A constant which can be used with the maintenance_type property of a MaintenanceEvent.
    #: This constant has a value of "AUTOMATIC"
    MAINTENANCE_TYPE_AUTOMATIC = "AUTOMATIC"

    #: A constant which can be used with the maintenance_type property of a MaintenanceEvent.
    #: This constant has a value of "MANUAL"
    MAINTENANCE_TYPE_MANUAL = "MANUAL"

    #: A constant which can be used with the maintenance_type property of a MaintenanceEvent.
    #: This constant has a value of "SHAPE"
    MAINTENANCE_TYPE_SHAPE = "SHAPE"

    #: A constant which can be used with the maintenance_action property of a MaintenanceEvent.
    #: This constant has a value of "DATABASE"
    MAINTENANCE_ACTION_DATABASE = "DATABASE"

    #: A constant which can be used with the maintenance_action property of a MaintenanceEvent.
    #: This constant has a value of "OS_UPDATE"
    MAINTENANCE_ACTION_OS_UPDATE = "OS_UPDATE"

    #: A constant which can be used with the maintenance_action property of a MaintenanceEvent.
    #: This constant has a value of "ONLINE_UPDATE"
    MAINTENANCE_ACTION_ONLINE_UPDATE = "ONLINE_UPDATE"

    #: A constant which can be used with the maintenance_action property of a MaintenanceEvent.
    #: This constant has a value of "HARDWARE"
    MAINTENANCE_ACTION_HARDWARE = "HARDWARE"

    #: A constant which can be used with the maintenance_status property of a MaintenanceEvent.
    #: This constant has a value of "SUCCEEDED"
    MAINTENANCE_STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the maintenance_status property of a MaintenanceEvent.
    #: This constant has a value of "FAILED"
    MAINTENANCE_STATUS_FAILED = "FAILED"

    #: A constant which can be used with the maintenance_status property of a MaintenanceEvent.
    #: This constant has a value of "CANCELED"
    MAINTENANCE_STATUS_CANCELED = "CANCELED"

    def __init__(self, **kwargs):
        """
        Initializes a new MaintenanceEvent object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_system_id:
            The value to assign to the db_system_id property of this MaintenanceEvent.
        :type db_system_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this MaintenanceEvent.
        :type compartment_id: str

        :param maintenance_notes:
            The value to assign to the maintenance_notes property of this MaintenanceEvent.
        :type maintenance_notes: str

        :param time_created:
            The value to assign to the time_created property of this MaintenanceEvent.
        :type time_created: datetime

        :param time_started:
            The value to assign to the time_started property of this MaintenanceEvent.
        :type time_started: datetime

        :param time_ended:
            The value to assign to the time_ended property of this MaintenanceEvent.
        :type time_ended: datetime

        :param time_mysql_switch_over_started:
            The value to assign to the time_mysql_switch_over_started property of this MaintenanceEvent.
        :type time_mysql_switch_over_started: datetime

        :param time_mysql_switch_over_ended:
            The value to assign to the time_mysql_switch_over_ended property of this MaintenanceEvent.
        :type time_mysql_switch_over_ended: datetime

        :param mysql_version_before_maintenance:
            The value to assign to the mysql_version_before_maintenance property of this MaintenanceEvent.
        :type mysql_version_before_maintenance: str

        :param mysql_version_after_maintenance:
            The value to assign to the mysql_version_after_maintenance property of this MaintenanceEvent.
        :type mysql_version_after_maintenance: str

        :param maintenance_scope:
            The value to assign to the maintenance_scope property of this MaintenanceEvent.
            Allowed values for this property are: "ALL", "ALL_BUT_PRIMARY", "PRIMARY_ONLY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type maintenance_scope: str

        :param maintenance_type:
            The value to assign to the maintenance_type property of this MaintenanceEvent.
            Allowed values for this property are: "AUTOMATIC", "MANUAL", "SHAPE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type maintenance_type: str

        :param maintenance_action:
            The value to assign to the maintenance_action property of this MaintenanceEvent.
            Allowed values for this property are: "DATABASE", "OS_UPDATE", "ONLINE_UPDATE", "HARDWARE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type maintenance_action: str

        :param maintenance_status:
            The value to assign to the maintenance_status property of this MaintenanceEvent.
            Allowed values for this property are: "SUCCEEDED", "FAILED", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type maintenance_status: str

        """
        self.swagger_types = {
            'db_system_id': 'str',
            'compartment_id': 'str',
            'maintenance_notes': 'str',
            'time_created': 'datetime',
            'time_started': 'datetime',
            'time_ended': 'datetime',
            'time_mysql_switch_over_started': 'datetime',
            'time_mysql_switch_over_ended': 'datetime',
            'mysql_version_before_maintenance': 'str',
            'mysql_version_after_maintenance': 'str',
            'maintenance_scope': 'str',
            'maintenance_type': 'str',
            'maintenance_action': 'str',
            'maintenance_status': 'str'
        }
        self.attribute_map = {
            'db_system_id': 'dbSystemId',
            'compartment_id': 'compartmentId',
            'maintenance_notes': 'maintenanceNotes',
            'time_created': 'timeCreated',
            'time_started': 'timeStarted',
            'time_ended': 'timeEnded',
            'time_mysql_switch_over_started': 'timeMysqlSwitchOverStarted',
            'time_mysql_switch_over_ended': 'timeMysqlSwitchOverEnded',
            'mysql_version_before_maintenance': 'mysqlVersionBeforeMaintenance',
            'mysql_version_after_maintenance': 'mysqlVersionAfterMaintenance',
            'maintenance_scope': 'maintenanceScope',
            'maintenance_type': 'maintenanceType',
            'maintenance_action': 'maintenanceAction',
            'maintenance_status': 'maintenanceStatus'
        }
        self._db_system_id = None
        self._compartment_id = None
        self._maintenance_notes = None
        self._time_created = None
        self._time_started = None
        self._time_ended = None
        self._time_mysql_switch_over_started = None
        self._time_mysql_switch_over_ended = None
        self._mysql_version_before_maintenance = None
        self._mysql_version_after_maintenance = None
        self._maintenance_scope = None
        self._maintenance_type = None
        self._maintenance_action = None
        self._maintenance_status = None

    @property
    def db_system_id(self):
        """
        **[Required]** Gets the db_system_id of this MaintenanceEvent.
        The OCID of the DB System this maintenance event is associated with.


        :return: The db_system_id of this MaintenanceEvent.
        :rtype: str
        """
        return self._db_system_id

    @db_system_id.setter
    def db_system_id(self, db_system_id):
        """
        Sets the db_system_id of this MaintenanceEvent.
        The OCID of the DB System this maintenance event is associated with.


        :param db_system_id: The db_system_id of this MaintenanceEvent.
        :type: str
        """
        self._db_system_id = db_system_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this MaintenanceEvent.
        The OCID of the compartment the maintenance event belongs to.


        :return: The compartment_id of this MaintenanceEvent.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this MaintenanceEvent.
        The OCID of the compartment the maintenance event belongs to.


        :param compartment_id: The compartment_id of this MaintenanceEvent.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def maintenance_notes(self):
        """
        Gets the maintenance_notes of this MaintenanceEvent.
        Information regarding what was performed during that maintenance.


        :return: The maintenance_notes of this MaintenanceEvent.
        :rtype: str
        """
        return self._maintenance_notes

    @maintenance_notes.setter
    def maintenance_notes(self, maintenance_notes):
        """
        Sets the maintenance_notes of this MaintenanceEvent.
        Information regarding what was performed during that maintenance.


        :param maintenance_notes: The maintenance_notes of this MaintenanceEvent.
        :type: str
        """
        self._maintenance_notes = maintenance_notes

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this MaintenanceEvent.
        The date and time the record was created,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this MaintenanceEvent.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this MaintenanceEvent.
        The date and time the record was created,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this MaintenanceEvent.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_started(self):
        """
        Gets the time_started of this MaintenanceEvent.
        The date and time the maintenance event started,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_started of this MaintenanceEvent.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this MaintenanceEvent.
        The date and time the maintenance event started,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_started: The time_started of this MaintenanceEvent.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_ended(self):
        """
        Gets the time_ended of this MaintenanceEvent.
        The date and time the maintenance event ended,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_ended of this MaintenanceEvent.
        :rtype: datetime
        """
        return self._time_ended

    @time_ended.setter
    def time_ended(self, time_ended):
        """
        Sets the time_ended of this MaintenanceEvent.
        The date and time the maintenance event ended,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_ended: The time_ended of this MaintenanceEvent.
        :type: datetime
        """
        self._time_ended = time_ended

    @property
    def time_mysql_switch_over_started(self):
        """
        Gets the time_mysql_switch_over_started of this MaintenanceEvent.
        The date and time the DB System was initially down during the maintenance,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_mysql_switch_over_started of this MaintenanceEvent.
        :rtype: datetime
        """
        return self._time_mysql_switch_over_started

    @time_mysql_switch_over_started.setter
    def time_mysql_switch_over_started(self, time_mysql_switch_over_started):
        """
        Sets the time_mysql_switch_over_started of this MaintenanceEvent.
        The date and time the DB System was initially down during the maintenance,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_mysql_switch_over_started: The time_mysql_switch_over_started of this MaintenanceEvent.
        :type: datetime
        """
        self._time_mysql_switch_over_started = time_mysql_switch_over_started

    @property
    def time_mysql_switch_over_ended(self):
        """
        Gets the time_mysql_switch_over_ended of this MaintenanceEvent.
        The date and time the DB System came back online during the maintenance,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_mysql_switch_over_ended of this MaintenanceEvent.
        :rtype: datetime
        """
        return self._time_mysql_switch_over_ended

    @time_mysql_switch_over_ended.setter
    def time_mysql_switch_over_ended(self, time_mysql_switch_over_ended):
        """
        Sets the time_mysql_switch_over_ended of this MaintenanceEvent.
        The date and time the DB System came back online during the maintenance,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_mysql_switch_over_ended: The time_mysql_switch_over_ended of this MaintenanceEvent.
        :type: datetime
        """
        self._time_mysql_switch_over_ended = time_mysql_switch_over_ended

    @property
    def mysql_version_before_maintenance(self):
        """
        **[Required]** Gets the mysql_version_before_maintenance of this MaintenanceEvent.
        The MySQL version prior to the maintenance.


        :return: The mysql_version_before_maintenance of this MaintenanceEvent.
        :rtype: str
        """
        return self._mysql_version_before_maintenance

    @mysql_version_before_maintenance.setter
    def mysql_version_before_maintenance(self, mysql_version_before_maintenance):
        """
        Sets the mysql_version_before_maintenance of this MaintenanceEvent.
        The MySQL version prior to the maintenance.


        :param mysql_version_before_maintenance: The mysql_version_before_maintenance of this MaintenanceEvent.
        :type: str
        """
        self._mysql_version_before_maintenance = mysql_version_before_maintenance

    @property
    def mysql_version_after_maintenance(self):
        """
        **[Required]** Gets the mysql_version_after_maintenance of this MaintenanceEvent.
        The MySQL version after the maintenance.


        :return: The mysql_version_after_maintenance of this MaintenanceEvent.
        :rtype: str
        """
        return self._mysql_version_after_maintenance

    @mysql_version_after_maintenance.setter
    def mysql_version_after_maintenance(self, mysql_version_after_maintenance):
        """
        Sets the mysql_version_after_maintenance of this MaintenanceEvent.
        The MySQL version after the maintenance.


        :param mysql_version_after_maintenance: The mysql_version_after_maintenance of this MaintenanceEvent.
        :type: str
        """
        self._mysql_version_after_maintenance = mysql_version_after_maintenance

    @property
    def maintenance_scope(self):
        """
        Gets the maintenance_scope of this MaintenanceEvent.
        The MySQL instances operated during a maintenance event.

        ALL:             maintenance event targeting all MySQL instances in a DB System.
        ALL_BUT_PRIMARY: maintenance event targeting all MySQL instances in a highly available DB System except the primary group member.
        PRIMARY_ONLY:    maintenance event targeting only the primary group member in a highly available DB System.

        Allowed values for this property are: "ALL", "ALL_BUT_PRIMARY", "PRIMARY_ONLY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The maintenance_scope of this MaintenanceEvent.
        :rtype: str
        """
        return self._maintenance_scope

    @maintenance_scope.setter
    def maintenance_scope(self, maintenance_scope):
        """
        Sets the maintenance_scope of this MaintenanceEvent.
        The MySQL instances operated during a maintenance event.

        ALL:             maintenance event targeting all MySQL instances in a DB System.
        ALL_BUT_PRIMARY: maintenance event targeting all MySQL instances in a highly available DB System except the primary group member.
        PRIMARY_ONLY:    maintenance event targeting only the primary group member in a highly available DB System.


        :param maintenance_scope: The maintenance_scope of this MaintenanceEvent.
        :type: str
        """
        allowed_values = ["ALL", "ALL_BUT_PRIMARY", "PRIMARY_ONLY"]
        if not value_allowed_none_or_none_sentinel(maintenance_scope, allowed_values):
            maintenance_scope = 'UNKNOWN_ENUM_VALUE'
        self._maintenance_scope = maintenance_scope

    @property
    def maintenance_type(self):
        """
        **[Required]** Gets the maintenance_type of this MaintenanceEvent.
        How the maintenance event was triggered.

        AUTOMATIC:  maintenance event triggered as part of scheduled maintenance.
        MANUAL:     maintenance event triggered manually.
        SHAPE:      maintenance event triggered by a shape update.

        Allowed values for this property are: "AUTOMATIC", "MANUAL", "SHAPE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The maintenance_type of this MaintenanceEvent.
        :rtype: str
        """
        return self._maintenance_type

    @maintenance_type.setter
    def maintenance_type(self, maintenance_type):
        """
        Sets the maintenance_type of this MaintenanceEvent.
        How the maintenance event was triggered.

        AUTOMATIC:  maintenance event triggered as part of scheduled maintenance.
        MANUAL:     maintenance event triggered manually.
        SHAPE:      maintenance event triggered by a shape update.


        :param maintenance_type: The maintenance_type of this MaintenanceEvent.
        :type: str
        """
        allowed_values = ["AUTOMATIC", "MANUAL", "SHAPE"]
        if not value_allowed_none_or_none_sentinel(maintenance_type, allowed_values):
            maintenance_type = 'UNKNOWN_ENUM_VALUE'
        self._maintenance_type = maintenance_type

    @property
    def maintenance_action(self):
        """
        **[Required]** Gets the maintenance_action of this MaintenanceEvent.
        The nature of the maintenance event.

        DATABASE:  maintenance event causing a MySQL version upgrade. This may also include OS updates.
        OS_UPDATE: maintenance event causing an OS update.
        ONLINE_UPDATE: maintenance event causing downtime-free OS security patches.
        HARDWARE: hardware maintenance event affecting the DB System's VMs and BMs.

        Allowed values for this property are: "DATABASE", "OS_UPDATE", "ONLINE_UPDATE", "HARDWARE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The maintenance_action of this MaintenanceEvent.
        :rtype: str
        """
        return self._maintenance_action

    @maintenance_action.setter
    def maintenance_action(self, maintenance_action):
        """
        Sets the maintenance_action of this MaintenanceEvent.
        The nature of the maintenance event.

        DATABASE:  maintenance event causing a MySQL version upgrade. This may also include OS updates.
        OS_UPDATE: maintenance event causing an OS update.
        ONLINE_UPDATE: maintenance event causing downtime-free OS security patches.
        HARDWARE: hardware maintenance event affecting the DB System's VMs and BMs.


        :param maintenance_action: The maintenance_action of this MaintenanceEvent.
        :type: str
        """
        allowed_values = ["DATABASE", "OS_UPDATE", "ONLINE_UPDATE", "HARDWARE"]
        if not value_allowed_none_or_none_sentinel(maintenance_action, allowed_values):
            maintenance_action = 'UNKNOWN_ENUM_VALUE'
        self._maintenance_action = maintenance_action

    @property
    def maintenance_status(self):
        """
        **[Required]** Gets the maintenance_status of this MaintenanceEvent.
        The last status of the maintenance event.

        Allowed values for this property are: "SUCCEEDED", "FAILED", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The maintenance_status of this MaintenanceEvent.
        :rtype: str
        """
        return self._maintenance_status

    @maintenance_status.setter
    def maintenance_status(self, maintenance_status):
        """
        Sets the maintenance_status of this MaintenanceEvent.
        The last status of the maintenance event.


        :param maintenance_status: The maintenance_status of this MaintenanceEvent.
        :type: str
        """
        allowed_values = ["SUCCEEDED", "FAILED", "CANCELED"]
        if not value_allowed_none_or_none_sentinel(maintenance_status, allowed_values):
            maintenance_status = 'UNKNOWN_ENUM_VALUE'
        self._maintenance_status = maintenance_status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
