# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaintenanceDisabledWindow(object):
    """
    Time window during which downtime-inducing maintenance shall not be performed.
    Downtime-free maintenance may be performed to apply required security patches.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MaintenanceDisabledWindow object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_start:
            The value to assign to the time_start property of this MaintenanceDisabledWindow.
        :type time_start: datetime

        :param time_end:
            The value to assign to the time_end property of this MaintenanceDisabledWindow.
        :type time_end: datetime

        """
        self.swagger_types = {
            'time_start': 'datetime',
            'time_end': 'datetime'
        }
        self.attribute_map = {
            'time_start': 'timeStart',
            'time_end': 'timeEnd'
        }
        self._time_start = None
        self._time_end = None

    @property
    def time_start(self):
        """
        **[Required]** Gets the time_start of this MaintenanceDisabledWindow.
        The time from when maintenance is disabled.
        Must be set together with timeEnd and must be before timeEnd.
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_start of this MaintenanceDisabledWindow.
        :rtype: datetime
        """
        return self._time_start

    @time_start.setter
    def time_start(self, time_start):
        """
        Sets the time_start of this MaintenanceDisabledWindow.
        The time from when maintenance is disabled.
        Must be set together with timeEnd and must be before timeEnd.
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_start: The time_start of this MaintenanceDisabledWindow.
        :type: datetime
        """
        self._time_start = time_start

    @property
    def time_end(self):
        """
        **[Required]** Gets the time_end of this MaintenanceDisabledWindow.
        The time until when maintenance is disabled.
        Must be set together with timeStart and must be after timeStart.
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_end of this MaintenanceDisabledWindow.
        :rtype: datetime
        """
        return self._time_end

    @time_end.setter
    def time_end(self, time_end):
        """
        Sets the time_end of this MaintenanceDisabledWindow.
        The time until when maintenance is disabled.
        Must be set together with timeStart and must be after timeStart.
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_end: The time_end of this MaintenanceDisabledWindow.
        :type: datetime
        """
        self._time_end = time_end

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
