# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenerateDbSystemStatusDetails(object):
    """
    Parameters for selecting which attributes to include in the DB System status.
    """

    #: A constant which can be used with the gtid_set_type property of a GenerateDbSystemStatusDetails.
    #: This constant has a value of "GTID_EXECUTED"
    GTID_SET_TYPE_GTID_EXECUTED = "GTID_EXECUTED"

    #: A constant which can be used with the gtid_set_type property of a GenerateDbSystemStatusDetails.
    #: This constant has a value of "GTID_AVAILABLE"
    GTID_SET_TYPE_GTID_AVAILABLE = "GTID_AVAILABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new GenerateDbSystemStatusDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param gtid_set_type:
            The value to assign to the gtid_set_type property of this GenerateDbSystemStatusDetails.
            Allowed values for this property are: "GTID_EXECUTED", "GTID_AVAILABLE"
        :type gtid_set_type: str

        :param gtid_set_to_apply:
            The value to assign to the gtid_set_to_apply property of this GenerateDbSystemStatusDetails.
        :type gtid_set_to_apply: str

        :param channel_ids:
            The value to assign to the channel_ids property of this GenerateDbSystemStatusDetails.
        :type channel_ids: list[str]

        """
        self.swagger_types = {
            'gtid_set_type': 'str',
            'gtid_set_to_apply': 'str',
            'channel_ids': 'list[str]'
        }
        self.attribute_map = {
            'gtid_set_type': 'gtidSetType',
            'gtid_set_to_apply': 'gtidSetToApply',
            'channel_ids': 'channelIds'
        }
        self._gtid_set_type = None
        self._gtid_set_to_apply = None
        self._channel_ids = None

    @property
    def gtid_set_type(self):
        """
        Gets the gtid_set_type of this GenerateDbSystemStatusDetails.
        Specifies whether to collect the full set of GTIDs executed on the DB System
        (`gtid_executed`__)
        or the set of GTIDs available in the DB System binary logs, not part of
        (`gtid_purged`__)
        (GTID_AVAILABLE, which is gtid_executed - gtid_purged).
        Use GTID_AVAILABLE if gtid_executed is too large to fit in the response.

        __ https://dev.mysql.com/doc/en/replication-options-gtids.html#sysvar_gtid_executed
        __ https://dev.mysql.com/doc/en/replication-options-gtids.html#sysvar_gtid_purged

        Allowed values for this property are: "GTID_EXECUTED", "GTID_AVAILABLE"


        :return: The gtid_set_type of this GenerateDbSystemStatusDetails.
        :rtype: str
        """
        return self._gtid_set_type

    @gtid_set_type.setter
    def gtid_set_type(self, gtid_set_type):
        """
        Sets the gtid_set_type of this GenerateDbSystemStatusDetails.
        Specifies whether to collect the full set of GTIDs executed on the DB System
        (`gtid_executed`__)
        or the set of GTIDs available in the DB System binary logs, not part of
        (`gtid_purged`__)
        (GTID_AVAILABLE, which is gtid_executed - gtid_purged).
        Use GTID_AVAILABLE if gtid_executed is too large to fit in the response.

        __ https://dev.mysql.com/doc/en/replication-options-gtids.html#sysvar_gtid_executed
        __ https://dev.mysql.com/doc/en/replication-options-gtids.html#sysvar_gtid_purged


        :param gtid_set_type: The gtid_set_type of this GenerateDbSystemStatusDetails.
        :type: str
        """
        allowed_values = ["GTID_EXECUTED", "GTID_AVAILABLE"]
        if not value_allowed_none_or_none_sentinel(gtid_set_type, allowed_values):
            raise ValueError(
                f"Invalid value for `gtid_set_type`, must be None or one of {allowed_values}"
            )
        self._gtid_set_type = gtid_set_type

    @property
    def gtid_set_to_apply(self):
        """
        Gets the gtid_set_to_apply of this GenerateDbSystemStatusDetails.
        Specifies the GTID set to be checked on the DB System to determine whether it has been applied. The result of
        the check is isGtidSetApplied in the response.


        :return: The gtid_set_to_apply of this GenerateDbSystemStatusDetails.
        :rtype: str
        """
        return self._gtid_set_to_apply

    @gtid_set_to_apply.setter
    def gtid_set_to_apply(self, gtid_set_to_apply):
        """
        Sets the gtid_set_to_apply of this GenerateDbSystemStatusDetails.
        Specifies the GTID set to be checked on the DB System to determine whether it has been applied. The result of
        the check is isGtidSetApplied in the response.


        :param gtid_set_to_apply: The gtid_set_to_apply of this GenerateDbSystemStatusDetails.
        :type: str
        """
        self._gtid_set_to_apply = gtid_set_to_apply

    @property
    def channel_ids(self):
        """
        Gets the channel_ids of this GenerateDbSystemStatusDetails.
        List of Channel IDs for which to collect status information.


        :return: The channel_ids of this GenerateDbSystemStatusDetails.
        :rtype: list[str]
        """
        return self._channel_ids

    @channel_ids.setter
    def channel_ids(self, channel_ids):
        """
        Sets the channel_ids of this GenerateDbSystemStatusDetails.
        List of Channel IDs for which to collect status information.


        :param channel_ids: The channel_ids of this GenerateDbSystemStatusDetails.
        :type: list[str]
        """
        self._channel_ids = channel_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
