# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportOptions(object):
    """
    The additional options used while exporting the DB system backup.
    """

    #: A constant which can be used with the data_format property of a ExportOptions.
    #: This constant has a value of "CSV"
    DATA_FORMAT_CSV = "CSV"

    #: A constant which can be used with the data_format property of a ExportOptions.
    #: This constant has a value of "TSV"
    DATA_FORMAT_TSV = "TSV"

    def __init__(self, **kwargs):
        """
        Initializes a new ExportOptions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compression_options:
            The value to assign to the compression_options property of this ExportOptions.
        :type compression_options: oci.mysql.models.CompressionOptions

        :param data_format:
            The value to assign to the data_format property of this ExportOptions.
            Allowed values for this property are: "CSV", "TSV"
        :type data_format: str

        :param folder_name:
            The value to assign to the folder_name property of this ExportOptions.
        :type folder_name: str

        """
        self.swagger_types = {
            'compression_options': 'CompressionOptions',
            'data_format': 'str',
            'folder_name': 'str'
        }
        self.attribute_map = {
            'compression_options': 'compressionOptions',
            'data_format': 'dataFormat',
            'folder_name': 'folderName'
        }
        self._compression_options = None
        self._data_format = None
        self._folder_name = None

    @property
    def compression_options(self):
        """
        Gets the compression_options of this ExportOptions.

        :return: The compression_options of this ExportOptions.
        :rtype: oci.mysql.models.CompressionOptions
        """
        return self._compression_options

    @compression_options.setter
    def compression_options(self, compression_options):
        """
        Sets the compression_options of this ExportOptions.

        :param compression_options: The compression_options of this ExportOptions.
        :type: oci.mysql.models.CompressionOptions
        """
        self._compression_options = compression_options

    @property
    def data_format(self):
        """
        Gets the data_format of this ExportOptions.
        The format used for storing data.

        Allowed values for this property are: "CSV", "TSV"


        :return: The data_format of this ExportOptions.
        :rtype: str
        """
        return self._data_format

    @data_format.setter
    def data_format(self, data_format):
        """
        Sets the data_format of this ExportOptions.
        The format used for storing data.


        :param data_format: The data_format of this ExportOptions.
        :type: str
        """
        allowed_values = ["CSV", "TSV"]
        if not value_allowed_none_or_none_sentinel(data_format, allowed_values):
            raise ValueError(
                f"Invalid value for `data_format`, must be None or one of {allowed_values}"
            )
        self._data_format = data_format

    @property
    def folder_name(self):
        """
        Gets the folder_name of this ExportOptions.
        The name of the folder in the Object Storage bucket where the dump files will be stored.
        A folder with the same name must not exist in the bucket. The folder will be created in the export process.


        :return: The folder_name of this ExportOptions.
        :rtype: str
        """
        return self._folder_name

    @folder_name.setter
    def folder_name(self, folder_name):
        """
        Sets the folder_name of this ExportOptions.
        The name of the folder in the Object Storage bucket where the dump files will be stored.
        A folder with the same name must not exist in the bucket. The folder will be created in the export process.


        :param folder_name: The folder_name of this ExportOptions.
        :type: str
        """
        self._folder_name = folder_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
