# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportBackupDetails(object):
    """
    The parameters required to export a DB system backup.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExportBackupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param bucket_name:
            The value to assign to the bucket_name property of this ExportBackupDetails.
        :type bucket_name: str

        :param export_options:
            The value to assign to the export_options property of this ExportBackupDetails.
        :type export_options: oci.mysql.models.ExportOptions

        :param namespace_name:
            The value to assign to the namespace_name property of this ExportBackupDetails.
        :type namespace_name: str

        :param subnet_id:
            The value to assign to the subnet_id property of this ExportBackupDetails.
        :type subnet_id: str

        """
        self.swagger_types = {
            'bucket_name': 'str',
            'export_options': 'ExportOptions',
            'namespace_name': 'str',
            'subnet_id': 'str'
        }
        self.attribute_map = {
            'bucket_name': 'bucketName',
            'export_options': 'exportOptions',
            'namespace_name': 'namespaceName',
            'subnet_id': 'subnetId'
        }
        self._bucket_name = None
        self._export_options = None
        self._namespace_name = None
        self._subnet_id = None

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this ExportBackupDetails.
        The Object Storage bucket name.


        :return: The bucket_name of this ExportBackupDetails.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this ExportBackupDetails.
        The Object Storage bucket name.


        :param bucket_name: The bucket_name of this ExportBackupDetails.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def export_options(self):
        """
        Gets the export_options of this ExportBackupDetails.

        :return: The export_options of this ExportBackupDetails.
        :rtype: oci.mysql.models.ExportOptions
        """
        return self._export_options

    @export_options.setter
    def export_options(self, export_options):
        """
        Sets the export_options of this ExportBackupDetails.

        :param export_options: The export_options of this ExportBackupDetails.
        :type: oci.mysql.models.ExportOptions
        """
        self._export_options = export_options

    @property
    def namespace_name(self):
        """
        **[Required]** Gets the namespace_name of this ExportBackupDetails.
        The Object Storage namespace.


        :return: The namespace_name of this ExportBackupDetails.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this ExportBackupDetails.
        The Object Storage namespace.


        :param namespace_name: The namespace_name of this ExportBackupDetails.
        :type: str
        """
        self._namespace_name = namespace_name

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this ExportBackupDetails.
        The OCID of the subnet which the temporary MySQL instance is associated with.
        If not specified, the subnet OCID of the DB system from which the backup is taken will be used by default.
        To export a backup copied from another region, it is mandatory to specify a valid subnet OCID in the current region.


        :return: The subnet_id of this ExportBackupDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this ExportBackupDetails.
        The OCID of the subnet which the temporary MySQL instance is associated with.
        If not specified, the subnet OCID of the DB system from which the backup is taken will be used by default.
        To export a backup copied from another region, it is mandatory to specify a valid subnet OCID in the current region.


        :param subnet_id: The subnet_id of this ExportBackupDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
