# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystemStatusResult(object):
    """
    The status collected from the DB System.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystemStatusResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param can_accept_client_connections:
            The value to assign to the can_accept_client_connections property of this DbSystemStatusResult.
        :type can_accept_client_connections: bool

        :param is_in_offline_mode:
            The value to assign to the is_in_offline_mode property of this DbSystemStatusResult.
        :type is_in_offline_mode: bool

        :param is_writable:
            The value to assign to the is_writable property of this DbSystemStatusResult.
        :type is_writable: bool

        :param are_all_mysql_instances_healthy:
            The value to assign to the are_all_mysql_instances_healthy property of this DbSystemStatusResult.
        :type are_all_mysql_instances_healthy: bool

        :param is_storage_full:
            The value to assign to the is_storage_full property of this DbSystemStatusResult.
        :type is_storage_full: bool

        :param gtid_set:
            The value to assign to the gtid_set property of this DbSystemStatusResult.
        :type gtid_set: str

        :param is_gtid_set_applied:
            The value to assign to the is_gtid_set_applied property of this DbSystemStatusResult.
        :type is_gtid_set_applied: bool

        :param channels_status:
            The value to assign to the channels_status property of this DbSystemStatusResult.
        :type channels_status: list[oci.mysql.models.ChannelStatusResult]

        """
        self.swagger_types = {
            'can_accept_client_connections': 'bool',
            'is_in_offline_mode': 'bool',
            'is_writable': 'bool',
            'are_all_mysql_instances_healthy': 'bool',
            'is_storage_full': 'bool',
            'gtid_set': 'str',
            'is_gtid_set_applied': 'bool',
            'channels_status': 'list[ChannelStatusResult]'
        }
        self.attribute_map = {
            'can_accept_client_connections': 'canAcceptClientConnections',
            'is_in_offline_mode': 'isInOfflineMode',
            'is_writable': 'isWritable',
            'are_all_mysql_instances_healthy': 'areAllMysqlInstancesHealthy',
            'is_storage_full': 'isStorageFull',
            'gtid_set': 'gtidSet',
            'is_gtid_set_applied': 'isGtidSetApplied',
            'channels_status': 'channelsStatus'
        }
        self._can_accept_client_connections = None
        self._is_in_offline_mode = None
        self._is_writable = None
        self._are_all_mysql_instances_healthy = None
        self._is_storage_full = None
        self._gtid_set = None
        self._is_gtid_set_applied = None
        self._channels_status = None

    @property
    def can_accept_client_connections(self):
        """
        Gets the can_accept_client_connections of this DbSystemStatusResult.
        Specifies if the Read/Write endpoint of the DB System can accept client connections.


        :return: The can_accept_client_connections of this DbSystemStatusResult.
        :rtype: bool
        """
        return self._can_accept_client_connections

    @can_accept_client_connections.setter
    def can_accept_client_connections(self, can_accept_client_connections):
        """
        Sets the can_accept_client_connections of this DbSystemStatusResult.
        Specifies if the Read/Write endpoint of the DB System can accept client connections.


        :param can_accept_client_connections: The can_accept_client_connections of this DbSystemStatusResult.
        :type: bool
        """
        self._can_accept_client_connections = can_accept_client_connections

    @property
    def is_in_offline_mode(self):
        """
        Gets the is_in_offline_mode of this DbSystemStatusResult.
        Specifies if the DB System is in offline mode based on the value of the MySQL system variable
        `offline_mode`__.
        If True, access is allowed only to users with specific privileges. If False, access is allowed for all MySQL
        user accounts.

        __ https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode


        :return: The is_in_offline_mode of this DbSystemStatusResult.
        :rtype: bool
        """
        return self._is_in_offline_mode

    @is_in_offline_mode.setter
    def is_in_offline_mode(self, is_in_offline_mode):
        """
        Sets the is_in_offline_mode of this DbSystemStatusResult.
        Specifies if the DB System is in offline mode based on the value of the MySQL system variable
        `offline_mode`__.
        If True, access is allowed only to users with specific privileges. If False, access is allowed for all MySQL
        user accounts.

        __ https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode


        :param is_in_offline_mode: The is_in_offline_mode of this DbSystemStatusResult.
        :type: bool
        """
        self._is_in_offline_mode = is_in_offline_mode

    @property
    def is_writable(self):
        """
        Gets the is_writable of this DbSystemStatusResult.
        Specifies if connected users can run write queries on the DB System.


        :return: The is_writable of this DbSystemStatusResult.
        :rtype: bool
        """
        return self._is_writable

    @is_writable.setter
    def is_writable(self, is_writable):
        """
        Sets the is_writable of this DbSystemStatusResult.
        Specifies if connected users can run write queries on the DB System.


        :param is_writable: The is_writable of this DbSystemStatusResult.
        :type: bool
        """
        self._is_writable = is_writable

    @property
    def are_all_mysql_instances_healthy(self):
        """
        Gets the are_all_mysql_instances_healthy of this DbSystemStatusResult.
        Specifies if the single MySQL instance in a standalone DB System or all MySQL instances in a highly available
        DB System (excluding read replicas) are healthy.


        :return: The are_all_mysql_instances_healthy of this DbSystemStatusResult.
        :rtype: bool
        """
        return self._are_all_mysql_instances_healthy

    @are_all_mysql_instances_healthy.setter
    def are_all_mysql_instances_healthy(self, are_all_mysql_instances_healthy):
        """
        Sets the are_all_mysql_instances_healthy of this DbSystemStatusResult.
        Specifies if the single MySQL instance in a standalone DB System or all MySQL instances in a highly available
        DB System (excluding read replicas) are healthy.


        :param are_all_mysql_instances_healthy: The are_all_mysql_instances_healthy of this DbSystemStatusResult.
        :type: bool
        """
        self._are_all_mysql_instances_healthy = are_all_mysql_instances_healthy

    @property
    def is_storage_full(self):
        """
        Gets the is_storage_full of this DbSystemStatusResult.
        Specifies if there is any MySQL instance (excluding read replicas) whose storage capacity is below [storage reserve]
        (https://docs.oracle.com/en-us/iaas/mysql-database/doc/health-monitor.html#GUID-C6CE25C7-B728-4C80-B548-A76B42005C83.html).


        :return: The is_storage_full of this DbSystemStatusResult.
        :rtype: bool
        """
        return self._is_storage_full

    @is_storage_full.setter
    def is_storage_full(self, is_storage_full):
        """
        Sets the is_storage_full of this DbSystemStatusResult.
        Specifies if there is any MySQL instance (excluding read replicas) whose storage capacity is below [storage reserve]
        (https://docs.oracle.com/en-us/iaas/mysql-database/doc/health-monitor.html#GUID-C6CE25C7-B728-4C80-B548-A76B42005C83.html).


        :param is_storage_full: The is_storage_full of this DbSystemStatusResult.
        :type: bool
        """
        self._is_storage_full = is_storage_full

    @property
    def gtid_set(self):
        """
        Gets the gtid_set of this DbSystemStatusResult.
        The GTID set on the DB System (either GTID_EXECUTED or GTID_AVAILABLE) as specified by the gtidSetType
        parameter in the request.


        :return: The gtid_set of this DbSystemStatusResult.
        :rtype: str
        """
        return self._gtid_set

    @gtid_set.setter
    def gtid_set(self, gtid_set):
        """
        Sets the gtid_set of this DbSystemStatusResult.
        The GTID set on the DB System (either GTID_EXECUTED or GTID_AVAILABLE) as specified by the gtidSetType
        parameter in the request.


        :param gtid_set: The gtid_set of this DbSystemStatusResult.
        :type: str
        """
        self._gtid_set = gtid_set

    @property
    def is_gtid_set_applied(self):
        """
        Gets the is_gtid_set_applied of this DbSystemStatusResult.
        Specifies if the GTID set in the gtidSetToApply parameter (if provided in the request) is fully applied
        on the DB System. If gtidSetToApply is not provided in the request or is \"\", this field will be empty.


        :return: The is_gtid_set_applied of this DbSystemStatusResult.
        :rtype: bool
        """
        return self._is_gtid_set_applied

    @is_gtid_set_applied.setter
    def is_gtid_set_applied(self, is_gtid_set_applied):
        """
        Sets the is_gtid_set_applied of this DbSystemStatusResult.
        Specifies if the GTID set in the gtidSetToApply parameter (if provided in the request) is fully applied
        on the DB System. If gtidSetToApply is not provided in the request or is \"\", this field will be empty.


        :param is_gtid_set_applied: The is_gtid_set_applied of this DbSystemStatusResult.
        :type: bool
        """
        self._is_gtid_set_applied = is_gtid_set_applied

    @property
    def channels_status(self):
        """
        Gets the channels_status of this DbSystemStatusResult.
        A list showing the status of the channels attached to the DB System for the requested channel IDs.


        :return: The channels_status of this DbSystemStatusResult.
        :rtype: list[oci.mysql.models.ChannelStatusResult]
        """
        return self._channels_status

    @channels_status.setter
    def channels_status(self, channels_status):
        """
        Sets the channels_status of this DbSystemStatusResult.
        A list showing the status of the channels attached to the DB System for the requested channel IDs.


        :param channels_status: The channels_status of this DbSystemStatusResult.
        :type: list[oci.mysql.models.ChannelStatusResult]
        """
        self._channels_status = channels_status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
