# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CspZoneKeyReferenceId(object):
    """
    This is CSP zone key reference
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CspZoneKeyReferenceId object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key_value:
            The value to assign to the key_value property of this CspZoneKeyReferenceId.
        :type key_value: str

        :param key_name:
            The value to assign to the key_name property of this CspZoneKeyReferenceId.
        :type key_name: str

        """
        self.swagger_types = {
            'key_value': 'str',
            'key_name': 'str'
        }
        self.attribute_map = {
            'key_value': 'keyValue',
            'key_name': 'keyName'
        }
        self._key_value = None
        self._key_name = None

    @property
    def key_value(self):
        """
        **[Required]** Gets the key_value of this CspZoneKeyReferenceId.
        Value of keyName
           GcpProjectName: A human-readable name for your project. The project name isn't used by any Google APIs. You can edit the project name at any time during or after project creation. Project names do not need to be unique.
           AzureSubscriptionId: A unique alphanumeric string that identifies your Azure subscription.
           AwsAccountId: a unique 12-digit number that identifies an Amazon Web Services (AWS) account


        :return: The key_value of this CspZoneKeyReferenceId.
        :rtype: str
        """
        return self._key_value

    @key_value.setter
    def key_value(self, key_value):
        """
        Sets the key_value of this CspZoneKeyReferenceId.
        Value of keyName
           GcpProjectName: A human-readable name for your project. The project name isn't used by any Google APIs. You can edit the project name at any time during or after project creation. Project names do not need to be unique.
           AzureSubscriptionId: A unique alphanumeric string that identifies your Azure subscription.
           AwsAccountId: a unique 12-digit number that identifies an Amazon Web Services (AWS) account


        :param key_value: The key_value of this CspZoneKeyReferenceId.
        :type: str
        """
        self._key_value = key_value

    @property
    def key_name(self):
        """
        **[Required]** Gets the key_name of this CspZoneKeyReferenceId.
        KeyName for Azure=AzureSubscriptionId Aws=AwsAccountId GCP=GcpProjectName


        :return: The key_name of this CspZoneKeyReferenceId.
        :rtype: str
        """
        return self._key_name

    @key_name.setter
    def key_name(self, key_name):
        """
        Sets the key_name of this CspZoneKeyReferenceId.
        KeyName for Azure=AzureSubscriptionId Aws=AwsAccountId GCP=GcpProjectName


        :param key_name: The key_name of this CspZoneKeyReferenceId.
        :type: str
        """
        self._key_name = key_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
