# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .pricing_plan import PricingPlan
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MeteredPricingPlan(PricingPlan):
    """
    Metered pricing plan.
    """

    #: A constant which can be used with the name property of a MeteredPricingPlan.
    #: This constant has a value of "PER_INSTANCE"
    NAME_PER_INSTANCE = "PER_INSTANCE"

    #: A constant which can be used with the name property of a MeteredPricingPlan.
    #: This constant has a value of "PER_OCPU_MIN_BILLING_HRS"
    NAME_PER_OCPU_MIN_BILLING_HRS = "PER_OCPU_MIN_BILLING_HRS"

    #: A constant which can be used with the name property of a MeteredPricingPlan.
    #: This constant has a value of "PER_OCPU_LINEAR"
    NAME_PER_OCPU_LINEAR = "PER_OCPU_LINEAR"

    #: A constant which can be used with the name property of a MeteredPricingPlan.
    #: This constant has a value of "PER_INSTANCE_MONTHLY_INCLUSIVE"
    NAME_PER_INSTANCE_MONTHLY_INCLUSIVE = "PER_INSTANCE_MONTHLY_INCLUSIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new MeteredPricingPlan object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.MeteredPricingPlan.plan_type` attribute
        of this class is ``METERED`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param plan_type:
            The value to assign to the plan_type property of this MeteredPricingPlan.
            Allowed values for this property are: "METERED", "FIXED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type plan_type: str

        :param rates:
            The value to assign to the rates property of this MeteredPricingPlan.
        :type rates: list[oci.marketplace_publisher.models.PricingRate]

        :param name:
            The value to assign to the name property of this MeteredPricingPlan.
            Allowed values for this property are: "PER_INSTANCE", "PER_OCPU_MIN_BILLING_HRS", "PER_OCPU_LINEAR", "PER_INSTANCE_MONTHLY_INCLUSIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type name: str

        :param extended_metadata:
            The value to assign to the extended_metadata property of this MeteredPricingPlan.
        :type extended_metadata: dict(str, str)

        """
        self.swagger_types = {
            'plan_type': 'str',
            'rates': 'list[PricingRate]',
            'name': 'str',
            'extended_metadata': 'dict(str, str)'
        }
        self.attribute_map = {
            'plan_type': 'planType',
            'rates': 'rates',
            'name': 'name',
            'extended_metadata': 'extendedMetadata'
        }
        self._plan_type = None
        self._rates = None
        self._name = None
        self._extended_metadata = None
        self._plan_type = 'METERED'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this MeteredPricingPlan.
        The listing's pricing plan name.

        Allowed values for this property are: "PER_INSTANCE", "PER_OCPU_MIN_BILLING_HRS", "PER_OCPU_LINEAR", "PER_INSTANCE_MONTHLY_INCLUSIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The name of this MeteredPricingPlan.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MeteredPricingPlan.
        The listing's pricing plan name.


        :param name: The name of this MeteredPricingPlan.
        :type: str
        """
        allowed_values = ["PER_INSTANCE", "PER_OCPU_MIN_BILLING_HRS", "PER_OCPU_LINEAR", "PER_INSTANCE_MONTHLY_INCLUSIVE"]
        if not value_allowed_none_or_none_sentinel(name, allowed_values):
            name = 'UNKNOWN_ENUM_VALUE'
        self._name = name

    @property
    def extended_metadata(self):
        """
        Gets the extended_metadata of this MeteredPricingPlan.
        Additional metadata key/value pairs for the metering pricing.


        :return: The extended_metadata of this MeteredPricingPlan.
        :rtype: dict(str, str)
        """
        return self._extended_metadata

    @extended_metadata.setter
    def extended_metadata(self, extended_metadata):
        """
        Sets the extended_metadata of this MeteredPricingPlan.
        Additional metadata key/value pairs for the metering pricing.


        :param extended_metadata: The extended_metadata of this MeteredPricingPlan.
        :type: dict(str, str)
        """
        self._extended_metadata = extended_metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
