# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FilterProperty(object):
    """
    Properties for the filter
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FilterProperty object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this FilterProperty.
        :type name: str

        :param code:
            The value to assign to the code property of this FilterProperty.
        :type code: str

        """
        self.swagger_types = {
            'name': 'str',
            'code': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'code': 'code'
        }
        self._name = None
        self._code = None

    @property
    def name(self):
        """
        Gets the name of this FilterProperty.
        Name of filter


        :return: The name of this FilterProperty.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FilterProperty.
        Name of filter


        :param name: The name of this FilterProperty.
        :type: str
        """
        self._name = name

    @property
    def code(self):
        """
        Gets the code of this FilterProperty.
        Filter code


        :return: The code of this FilterProperty.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this FilterProperty.
        Filter code


        :param code: The code of this FilterProperty.
        :type: str
        """
        self._code = code

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
