# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ParserTestResultFieldValue(object):
    """
    A parser test result field value object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ParserTestResultFieldValue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param position:
            The value to assign to the position property of this ParserTestResultFieldValue.
        :type position: int

        :param field_name:
            The value to assign to the field_name property of this ParserTestResultFieldValue.
        :type field_name: str

        :param value:
            The value to assign to the value property of this ParserTestResultFieldValue.
        :type value: str

        :param parser_name:
            The value to assign to the parser_name property of this ParserTestResultFieldValue.
        :type parser_name: str

        :param sub_parser_result:
            The value to assign to the sub_parser_result property of this ParserTestResultFieldValue.
        :type sub_parser_result: oci.log_analytics.models.ParserTestResult

        """
        self.swagger_types = {
            'position': 'int',
            'field_name': 'str',
            'value': 'str',
            'parser_name': 'str',
            'sub_parser_result': 'ParserTestResult'
        }
        self.attribute_map = {
            'position': 'position',
            'field_name': 'fieldName',
            'value': 'value',
            'parser_name': 'parserName',
            'sub_parser_result': 'subParserResult'
        }
        self._position = None
        self._field_name = None
        self._value = None
        self._parser_name = None
        self._sub_parser_result = None

    @property
    def position(self):
        """
        Gets the position of this ParserTestResultFieldValue.
        The field position.


        :return: The position of this ParserTestResultFieldValue.
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this ParserTestResultFieldValue.
        The field position.


        :param position: The position of this ParserTestResultFieldValue.
        :type: int
        """
        self._position = position

    @property
    def field_name(self):
        """
        Gets the field_name of this ParserTestResultFieldValue.
        The field name.


        :return: The field_name of this ParserTestResultFieldValue.
        :rtype: str
        """
        return self._field_name

    @field_name.setter
    def field_name(self, field_name):
        """
        Sets the field_name of this ParserTestResultFieldValue.
        The field name.


        :param field_name: The field_name of this ParserTestResultFieldValue.
        :type: str
        """
        self._field_name = field_name

    @property
    def value(self):
        """
        Gets the value of this ParserTestResultFieldValue.
        The field value.


        :return: The value of this ParserTestResultFieldValue.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this ParserTestResultFieldValue.
        The field value.


        :param value: The value of this ParserTestResultFieldValue.
        :type: str
        """
        self._value = value

    @property
    def parser_name(self):
        """
        Gets the parser_name of this ParserTestResultFieldValue.
        The sub parser name.


        :return: The parser_name of this ParserTestResultFieldValue.
        :rtype: str
        """
        return self._parser_name

    @parser_name.setter
    def parser_name(self, parser_name):
        """
        Sets the parser_name of this ParserTestResultFieldValue.
        The sub parser name.


        :param parser_name: The parser_name of this ParserTestResultFieldValue.
        :type: str
        """
        self._parser_name = parser_name

    @property
    def sub_parser_result(self):
        """
        Gets the sub_parser_result of this ParserTestResultFieldValue.

        :return: The sub_parser_result of this ParserTestResultFieldValue.
        :rtype: oci.log_analytics.models.ParserTestResult
        """
        return self._sub_parser_result

    @sub_parser_result.setter
    def sub_parser_result(self, sub_parser_result):
        """
        Sets the sub_parser_result of this ParserTestResultFieldValue.

        :param sub_parser_result: The sub_parser_result of this ParserTestResultFieldValue.
        :type: oci.log_analytics.models.ParserTestResult
        """
        self._sub_parser_result = sub_parser_result

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
