# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EstimateReleaseDataSizeDetails(object):
    """
    This is the input used to estimate the size of data to be released
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EstimateReleaseDataSizeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_data_started:
            The value to assign to the time_data_started property of this EstimateReleaseDataSizeDetails.
        :type time_data_started: datetime

        :param time_data_ended:
            The value to assign to the time_data_ended property of this EstimateReleaseDataSizeDetails.
        :type time_data_ended: datetime

        :param collection_id:
            The value to assign to the collection_id property of this EstimateReleaseDataSizeDetails.
        :type collection_id: int

        """
        self.swagger_types = {
            'time_data_started': 'datetime',
            'time_data_ended': 'datetime',
            'collection_id': 'int'
        }
        self.attribute_map = {
            'time_data_started': 'timeDataStarted',
            'time_data_ended': 'timeDataEnded',
            'collection_id': 'collectionId'
        }
        self._time_data_started = None
        self._time_data_ended = None
        self._collection_id = None

    @property
    def time_data_started(self):
        """
        **[Required]** Gets the time_data_started of this EstimateReleaseDataSizeDetails.
        This is the start of the time range for the data to be released


        :return: The time_data_started of this EstimateReleaseDataSizeDetails.
        :rtype: datetime
        """
        return self._time_data_started

    @time_data_started.setter
    def time_data_started(self, time_data_started):
        """
        Sets the time_data_started of this EstimateReleaseDataSizeDetails.
        This is the start of the time range for the data to be released


        :param time_data_started: The time_data_started of this EstimateReleaseDataSizeDetails.
        :type: datetime
        """
        self._time_data_started = time_data_started

    @property
    def time_data_ended(self):
        """
        **[Required]** Gets the time_data_ended of this EstimateReleaseDataSizeDetails.
        This is the end of the time range for the data to be released


        :return: The time_data_ended of this EstimateReleaseDataSizeDetails.
        :rtype: datetime
        """
        return self._time_data_ended

    @time_data_ended.setter
    def time_data_ended(self, time_data_ended):
        """
        Sets the time_data_ended of this EstimateReleaseDataSizeDetails.
        This is the end of the time range for the data to be released


        :param time_data_ended: The time_data_ended of this EstimateReleaseDataSizeDetails.
        :type: datetime
        """
        self._time_data_ended = time_data_ended

    @property
    def collection_id(self):
        """
        Gets the collection_id of this EstimateReleaseDataSizeDetails.
        This is the id for the recalled data collection to be released.
        If specified, only this collection will be released


        :return: The collection_id of this EstimateReleaseDataSizeDetails.
        :rtype: int
        """
        return self._collection_id

    @collection_id.setter
    def collection_id(self, collection_id):
        """
        Sets the collection_id of this EstimateReleaseDataSizeDetails.
        This is the id for the recalled data collection to be released.
        If specified, only this collection will be released


        :param collection_id: The collection_id of this EstimateReleaseDataSizeDetails.
        :type: int
        """
        self._collection_id = collection_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
