# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601

from .schedule import Schedule
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AutoSchedule(Schedule):
    """
    Auto Fixed frequency schedule for a scheduled task.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AutoSchedule object with values from keyword arguments. The default value of the :py:attr:`~oci.log_analytics.models.AutoSchedule.type` attribute
        of this class is ``AUTO`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this AutoSchedule.
            Allowed values for this property are: "FIXED_FREQUENCY", "CRON", "AUTO"
        :type type: str

        :param misfire_policy:
            The value to assign to the misfire_policy property of this AutoSchedule.
            Allowed values for this property are: "RETRY_ONCE", "RETRY_INDEFINITELY", "SKIP"
        :type misfire_policy: str

        :param time_of_first_execution:
            The value to assign to the time_of_first_execution property of this AutoSchedule.
        :type time_of_first_execution: datetime

        :param query_offset_secs:
            The value to assign to the query_offset_secs property of this AutoSchedule.
        :type query_offset_secs: int

        :param time_end:
            The value to assign to the time_end property of this AutoSchedule.
        :type time_end: datetime

        """
        self.swagger_types = {
            'type': 'str',
            'misfire_policy': 'str',
            'time_of_first_execution': 'datetime',
            'query_offset_secs': 'int',
            'time_end': 'datetime'
        }
        self.attribute_map = {
            'type': 'type',
            'misfire_policy': 'misfirePolicy',
            'time_of_first_execution': 'timeOfFirstExecution',
            'query_offset_secs': 'queryOffsetSecs',
            'time_end': 'timeEnd'
        }
        self._type = None
        self._misfire_policy = None
        self._time_of_first_execution = None
        self._query_offset_secs = None
        self._time_end = None
        self._type = 'AUTO'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
