# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AbstractParserTestResultLogLine(object):
    """
    AbstractParserTestResultLogLine
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AbstractParserTestResultLogLine object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param original_log_line:
            The value to assign to the original_log_line property of this AbstractParserTestResultLogLine.
        :type original_log_line: str

        :param pre_processed_log_line:
            The value to assign to the pre_processed_log_line property of this AbstractParserTestResultLogLine.
        :type pre_processed_log_line: str

        :param find_start_index:
            The value to assign to the find_start_index property of this AbstractParserTestResultLogLine.
        :type find_start_index: int

        :param find_end_index:
            The value to assign to the find_end_index property of this AbstractParserTestResultLogLine.
        :type find_end_index: int

        :param replace_string:
            The value to assign to the replace_string property of this AbstractParserTestResultLogLine.
        :type replace_string: str

        :param replace_start_index:
            The value to assign to the replace_start_index property of this AbstractParserTestResultLogLine.
        :type replace_start_index: int

        :param replace_end_index:
            The value to assign to the replace_end_index property of this AbstractParserTestResultLogLine.
        :type replace_end_index: int

        :param grp_name_value_map:
            The value to assign to the grp_name_value_map property of this AbstractParserTestResultLogLine.
        :type grp_name_value_map: dict(str, NamedCaptureValue)

        """
        self.swagger_types = {
            'original_log_line': 'str',
            'pre_processed_log_line': 'str',
            'find_start_index': 'int',
            'find_end_index': 'int',
            'replace_string': 'str',
            'replace_start_index': 'int',
            'replace_end_index': 'int',
            'grp_name_value_map': 'dict(str, NamedCaptureValue)'
        }
        self.attribute_map = {
            'original_log_line': 'originalLogLine',
            'pre_processed_log_line': 'preProcessedLogLine',
            'find_start_index': 'findStartIndex',
            'find_end_index': 'findEndIndex',
            'replace_string': 'replaceString',
            'replace_start_index': 'replaceStartIndex',
            'replace_end_index': 'replaceEndIndex',
            'grp_name_value_map': 'grpNameValueMap'
        }
        self._original_log_line = None
        self._pre_processed_log_line = None
        self._find_start_index = None
        self._find_end_index = None
        self._replace_string = None
        self._replace_start_index = None
        self._replace_end_index = None
        self._grp_name_value_map = None

    @property
    def original_log_line(self):
        """
        Gets the original_log_line of this AbstractParserTestResultLogLine.
        The original log line.


        :return: The original_log_line of this AbstractParserTestResultLogLine.
        :rtype: str
        """
        return self._original_log_line

    @original_log_line.setter
    def original_log_line(self, original_log_line):
        """
        Sets the original_log_line of this AbstractParserTestResultLogLine.
        The original log line.


        :param original_log_line: The original_log_line of this AbstractParserTestResultLogLine.
        :type: str
        """
        self._original_log_line = original_log_line

    @property
    def pre_processed_log_line(self):
        """
        Gets the pre_processed_log_line of this AbstractParserTestResultLogLine.
        The pre-processed log line.


        :return: The pre_processed_log_line of this AbstractParserTestResultLogLine.
        :rtype: str
        """
        return self._pre_processed_log_line

    @pre_processed_log_line.setter
    def pre_processed_log_line(self, pre_processed_log_line):
        """
        Sets the pre_processed_log_line of this AbstractParserTestResultLogLine.
        The pre-processed log line.


        :param pre_processed_log_line: The pre_processed_log_line of this AbstractParserTestResultLogLine.
        :type: str
        """
        self._pre_processed_log_line = pre_processed_log_line

    @property
    def find_start_index(self):
        """
        Gets the find_start_index of this AbstractParserTestResultLogLine.
        The find start index.


        :return: The find_start_index of this AbstractParserTestResultLogLine.
        :rtype: int
        """
        return self._find_start_index

    @find_start_index.setter
    def find_start_index(self, find_start_index):
        """
        Sets the find_start_index of this AbstractParserTestResultLogLine.
        The find start index.


        :param find_start_index: The find_start_index of this AbstractParserTestResultLogLine.
        :type: int
        """
        self._find_start_index = find_start_index

    @property
    def find_end_index(self):
        """
        Gets the find_end_index of this AbstractParserTestResultLogLine.
        The find end index.


        :return: The find_end_index of this AbstractParserTestResultLogLine.
        :rtype: int
        """
        return self._find_end_index

    @find_end_index.setter
    def find_end_index(self, find_end_index):
        """
        Sets the find_end_index of this AbstractParserTestResultLogLine.
        The find end index.


        :param find_end_index: The find_end_index of this AbstractParserTestResultLogLine.
        :type: int
        """
        self._find_end_index = find_end_index

    @property
    def replace_string(self):
        """
        Gets the replace_string of this AbstractParserTestResultLogLine.
        The replacement string.


        :return: The replace_string of this AbstractParserTestResultLogLine.
        :rtype: str
        """
        return self._replace_string

    @replace_string.setter
    def replace_string(self, replace_string):
        """
        Sets the replace_string of this AbstractParserTestResultLogLine.
        The replacement string.


        :param replace_string: The replace_string of this AbstractParserTestResultLogLine.
        :type: str
        """
        self._replace_string = replace_string

    @property
    def replace_start_index(self):
        """
        Gets the replace_start_index of this AbstractParserTestResultLogLine.
        The replace start index.


        :return: The replace_start_index of this AbstractParserTestResultLogLine.
        :rtype: int
        """
        return self._replace_start_index

    @replace_start_index.setter
    def replace_start_index(self, replace_start_index):
        """
        Sets the replace_start_index of this AbstractParserTestResultLogLine.
        The replace start index.


        :param replace_start_index: The replace_start_index of this AbstractParserTestResultLogLine.
        :type: int
        """
        self._replace_start_index = replace_start_index

    @property
    def replace_end_index(self):
        """
        Gets the replace_end_index of this AbstractParserTestResultLogLine.
        The replace end index.


        :return: The replace_end_index of this AbstractParserTestResultLogLine.
        :rtype: int
        """
        return self._replace_end_index

    @replace_end_index.setter
    def replace_end_index(self, replace_end_index):
        """
        Sets the replace_end_index of this AbstractParserTestResultLogLine.
        The replace end index.


        :param replace_end_index: The replace_end_index of this AbstractParserTestResultLogLine.
        :type: int
        """
        self._replace_end_index = replace_end_index

    @property
    def grp_name_value_map(self):
        """
        Gets the grp_name_value_map of this AbstractParserTestResultLogLine.
        The group name value map.


        :return: The grp_name_value_map of this AbstractParserTestResultLogLine.
        :rtype: dict(str, NamedCaptureValue)
        """
        return self._grp_name_value_map

    @grp_name_value_map.setter
    def grp_name_value_map(self, grp_name_value_map):
        """
        Sets the grp_name_value_map of this AbstractParserTestResultLogLine.
        The group name value map.


        :param grp_name_value_map: The grp_name_value_map of this AbstractParserTestResultLogLine.
        :type: dict(str, NamedCaptureValue)
        """
        self._grp_name_value_map = grp_name_value_map

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
