# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250521


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PerformanceTuningAnalysisTarget(object):
    """
    The target for the Performance Tuning Analysis
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PerformanceTuningAnalysisTarget object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param analysis_project_name:
            The value to assign to the analysis_project_name property of this PerformanceTuningAnalysisTarget.
        :type analysis_project_name: str

        :param artifact_object_storage_path:
            The value to assign to the artifact_object_storage_path property of this PerformanceTuningAnalysisTarget.
        :type artifact_object_storage_path: str

        """
        self.swagger_types = {
            'analysis_project_name': 'str',
            'artifact_object_storage_path': 'str'
        }
        self.attribute_map = {
            'analysis_project_name': 'analysisProjectName',
            'artifact_object_storage_path': 'artifactObjectStoragePath'
        }
        self._analysis_project_name = None
        self._artifact_object_storage_path = None

    @property
    def analysis_project_name(self):
        """
        **[Required]** Gets the analysis_project_name of this PerformanceTuningAnalysisTarget.
        Name of the analysis project.


        :return: The analysis_project_name of this PerformanceTuningAnalysisTarget.
        :rtype: str
        """
        return self._analysis_project_name

    @analysis_project_name.setter
    def analysis_project_name(self, analysis_project_name):
        """
        Sets the analysis_project_name of this PerformanceTuningAnalysisTarget.
        Name of the analysis project.


        :param analysis_project_name: The analysis_project_name of this PerformanceTuningAnalysisTarget.
        :type: str
        """
        self._analysis_project_name = analysis_project_name

    @property
    def artifact_object_storage_path(self):
        """
        **[Required]** Gets the artifact_object_storage_path of this PerformanceTuningAnalysisTarget.
        Object storage path to the artifact.


        :return: The artifact_object_storage_path of this PerformanceTuningAnalysisTarget.
        :rtype: str
        """
        return self._artifact_object_storage_path

    @artifact_object_storage_path.setter
    def artifact_object_storage_path(self, artifact_object_storage_path):
        """
        Sets the artifact_object_storage_path of this PerformanceTuningAnalysisTarget.
        Object storage path to the artifact.


        :param artifact_object_storage_path: The artifact_object_storage_path of this PerformanceTuningAnalysisTarget.
        :type: str
        """
        self._artifact_object_storage_path = artifact_object_storage_path

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
