# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531

from .invoke_raw_command_details import InvokeRawCommandDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InvokeRawBinaryCommandDetails(InvokeRawCommandDetails):
    """
    Binary data payload definition
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InvokeRawBinaryCommandDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.iot.models.InvokeRawBinaryCommandDetails.request_data_format` attribute
        of this class is ``BINARY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param request_duration:
            The value to assign to the request_duration property of this InvokeRawBinaryCommandDetails.
        :type request_duration: str

        :param response_duration:
            The value to assign to the response_duration property of this InvokeRawBinaryCommandDetails.
        :type response_duration: str

        :param request_endpoint:
            The value to assign to the request_endpoint property of this InvokeRawBinaryCommandDetails.
        :type request_endpoint: str

        :param response_endpoint:
            The value to assign to the response_endpoint property of this InvokeRawBinaryCommandDetails.
        :type response_endpoint: str

        :param request_data_format:
            The value to assign to the request_data_format property of this InvokeRawBinaryCommandDetails.
            Allowed values for this property are: "TEXT", "JSON", "BINARY"
        :type request_data_format: str

        :param request_data_content_type:
            The value to assign to the request_data_content_type property of this InvokeRawBinaryCommandDetails.
        :type request_data_content_type: str

        :param request_data:
            The value to assign to the request_data property of this InvokeRawBinaryCommandDetails.
        :type request_data: str

        """
        self.swagger_types = {
            'request_duration': 'str',
            'response_duration': 'str',
            'request_endpoint': 'str',
            'response_endpoint': 'str',
            'request_data_format': 'str',
            'request_data_content_type': 'str',
            'request_data': 'str'
        }
        self.attribute_map = {
            'request_duration': 'requestDuration',
            'response_duration': 'responseDuration',
            'request_endpoint': 'requestEndpoint',
            'response_endpoint': 'responseEndpoint',
            'request_data_format': 'requestDataFormat',
            'request_data_content_type': 'requestDataContentType',
            'request_data': 'requestData'
        }
        self._request_duration = None
        self._response_duration = None
        self._request_endpoint = None
        self._response_endpoint = None
        self._request_data_format = None
        self._request_data_content_type = None
        self._request_data = None
        self._request_data_format = 'BINARY'

    @property
    def request_data_content_type(self):
        """
        Gets the request_data_content_type of this InvokeRawBinaryCommandDetails.
        Mime content type of data encoded using base64, default is application/octet-stream


        :return: The request_data_content_type of this InvokeRawBinaryCommandDetails.
        :rtype: str
        """
        return self._request_data_content_type

    @request_data_content_type.setter
    def request_data_content_type(self, request_data_content_type):
        """
        Sets the request_data_content_type of this InvokeRawBinaryCommandDetails.
        Mime content type of data encoded using base64, default is application/octet-stream


        :param request_data_content_type: The request_data_content_type of this InvokeRawBinaryCommandDetails.
        :type: str
        """
        self._request_data_content_type = request_data_content_type

    @property
    def request_data(self):
        """
        Gets the request_data of this InvokeRawBinaryCommandDetails.
        base 64 encoded request data


        :return: The request_data of this InvokeRawBinaryCommandDetails.
        :rtype: str
        """
        return self._request_data

    @request_data.setter
    def request_data(self, request_data):
        """
        Sets the request_data of this InvokeRawBinaryCommandDetails.
        base 64 encoded request data


        :param request_data: The request_data of this InvokeRawBinaryCommandDetails.
        :type: str
        """
        self._request_data = request_data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
