# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DigitalTwinAdapterInboundRoute(object):
    """
    Defines how inbound device payloads should be routed and mapped within a digital twin context.
    Routes are evaluated in the order they are defined, and only the first matching
    condition is processed. A final default route (with
    a condition that always evaluates to true) is recommended for fallback handling.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DigitalTwinAdapterInboundRoute object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param condition:
            The value to assign to the condition property of this DigitalTwinAdapterInboundRoute.
        :type condition: str

        :param reference_payload:
            The value to assign to the reference_payload property of this DigitalTwinAdapterInboundRoute.
        :type reference_payload: oci.iot.models.DigitalTwinAdapterPayload

        :param payload_mapping:
            The value to assign to the payload_mapping property of this DigitalTwinAdapterInboundRoute.
        :type payload_mapping: dict(str, str)

        :param description:
            The value to assign to the description property of this DigitalTwinAdapterInboundRoute.
        :type description: str

        """
        self.swagger_types = {
            'condition': 'str',
            'reference_payload': 'DigitalTwinAdapterPayload',
            'payload_mapping': 'dict(str, str)',
            'description': 'str'
        }
        self.attribute_map = {
            'condition': 'condition',
            'reference_payload': 'referencePayload',
            'payload_mapping': 'payloadMapping',
            'description': 'description'
        }
        self._condition = None
        self._reference_payload = None
        self._payload_mapping = None
        self._description = None

    @property
    def condition(self):
        """
        **[Required]** Gets the condition of this DigitalTwinAdapterInboundRoute.
        A boolean expression used to determine whether the following transformation
        should be processed for the incoming payload. This expression is typically based
        on fields defined at the inbound Envelope and is evaluated before applying the `payloadMapping`.


        :return: The condition of this DigitalTwinAdapterInboundRoute.
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """
        Sets the condition of this DigitalTwinAdapterInboundRoute.
        A boolean expression used to determine whether the following transformation
        should be processed for the incoming payload. This expression is typically based
        on fields defined at the inbound Envelope and is evaluated before applying the `payloadMapping`.


        :param condition: The condition of this DigitalTwinAdapterInboundRoute.
        :type: str
        """
        self._condition = condition

    @property
    def reference_payload(self):
        """
        Gets the reference_payload of this DigitalTwinAdapterInboundRoute.

        :return: The reference_payload of this DigitalTwinAdapterInboundRoute.
        :rtype: oci.iot.models.DigitalTwinAdapterPayload
        """
        return self._reference_payload

    @reference_payload.setter
    def reference_payload(self, reference_payload):
        """
        Sets the reference_payload of this DigitalTwinAdapterInboundRoute.

        :param reference_payload: The reference_payload of this DigitalTwinAdapterInboundRoute.
        :type: oci.iot.models.DigitalTwinAdapterPayload
        """
        self._reference_payload = reference_payload

    @property
    def payload_mapping(self):
        """
        Gets the payload_mapping of this DigitalTwinAdapterInboundRoute.
        A set of key-value JQ expressions used to transform the incoming payload into a shape
        compatible with the digital twin model's context or schema.

        The keys are target fields (in the digital twin model), and values are JQ expressions
        pointing to data in the reference payload.

        Example:
        Given payload:
        {
          \"time\": \"<timestamp>\",
          \"temp\": 65,
          \"hum\": 55
        }
        And mapping:
        {
          \"temperature\": \"$.temp\",
          \"humidity\": \"$.hum\",
          \"timeObserved\": \"$.time\"
        }
        The output will be:
        {
          \"temperature\": 65,
          \"humidity\": 55,
          \"timeObserved\": \"<timestamp>\"
        }


        :return: The payload_mapping of this DigitalTwinAdapterInboundRoute.
        :rtype: dict(str, str)
        """
        return self._payload_mapping

    @payload_mapping.setter
    def payload_mapping(self, payload_mapping):
        """
        Sets the payload_mapping of this DigitalTwinAdapterInboundRoute.
        A set of key-value JQ expressions used to transform the incoming payload into a shape
        compatible with the digital twin model's context or schema.

        The keys are target fields (in the digital twin model), and values are JQ expressions
        pointing to data in the reference payload.

        Example:
        Given payload:
        {
          \"time\": \"<timestamp>\",
          \"temp\": 65,
          \"hum\": 55
        }
        And mapping:
        {
          \"temperature\": \"$.temp\",
          \"humidity\": \"$.hum\",
          \"timeObserved\": \"$.time\"
        }
        The output will be:
        {
          \"temperature\": 65,
          \"humidity\": 55,
          \"timeObserved\": \"<timestamp>\"
        }


        :param payload_mapping: The payload_mapping of this DigitalTwinAdapterInboundRoute.
        :type: dict(str, str)
        """
        self._payload_mapping = payload_mapping

    @property
    def description(self):
        """
        Gets the description of this DigitalTwinAdapterInboundRoute.
        Meaningful write up about the inbound route.


        :return: The description of this DigitalTwinAdapterInboundRoute.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DigitalTwinAdapterInboundRoute.
        Meaningful write up about the inbound route.


        :param description: The description of this DigitalTwinAdapterInboundRoute.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
