# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDigitalTwinAdapterDetails(object):
    """
    The information about new digital twin adapter to be created.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDigitalTwinAdapterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param iot_domain_id:
            The value to assign to the iot_domain_id property of this CreateDigitalTwinAdapterDetails.
        :type iot_domain_id: str

        :param digital_twin_model_id:
            The value to assign to the digital_twin_model_id property of this CreateDigitalTwinAdapterDetails.
        :type digital_twin_model_id: str

        :param digital_twin_model_spec_uri:
            The value to assign to the digital_twin_model_spec_uri property of this CreateDigitalTwinAdapterDetails.
        :type digital_twin_model_spec_uri: str

        :param display_name:
            The value to assign to the display_name property of this CreateDigitalTwinAdapterDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateDigitalTwinAdapterDetails.
        :type description: str

        :param inbound_envelope:
            The value to assign to the inbound_envelope property of this CreateDigitalTwinAdapterDetails.
        :type inbound_envelope: oci.iot.models.DigitalTwinAdapterInboundEnvelope

        :param inbound_routes:
            The value to assign to the inbound_routes property of this CreateDigitalTwinAdapterDetails.
        :type inbound_routes: list[oci.iot.models.DigitalTwinAdapterInboundRoute]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDigitalTwinAdapterDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDigitalTwinAdapterDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'iot_domain_id': 'str',
            'digital_twin_model_id': 'str',
            'digital_twin_model_spec_uri': 'str',
            'display_name': 'str',
            'description': 'str',
            'inbound_envelope': 'DigitalTwinAdapterInboundEnvelope',
            'inbound_routes': 'list[DigitalTwinAdapterInboundRoute]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'iot_domain_id': 'iotDomainId',
            'digital_twin_model_id': 'digitalTwinModelId',
            'digital_twin_model_spec_uri': 'digitalTwinModelSpecUri',
            'display_name': 'displayName',
            'description': 'description',
            'inbound_envelope': 'inboundEnvelope',
            'inbound_routes': 'inboundRoutes',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._iot_domain_id = None
        self._digital_twin_model_id = None
        self._digital_twin_model_spec_uri = None
        self._display_name = None
        self._description = None
        self._inbound_envelope = None
        self._inbound_routes = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def iot_domain_id(self):
        """
        **[Required]** Gets the iot_domain_id of this CreateDigitalTwinAdapterDetails.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The iot_domain_id of this CreateDigitalTwinAdapterDetails.
        :rtype: str
        """
        return self._iot_domain_id

    @iot_domain_id.setter
    def iot_domain_id(self, iot_domain_id):
        """
        Sets the iot_domain_id of this CreateDigitalTwinAdapterDetails.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param iot_domain_id: The iot_domain_id of this CreateDigitalTwinAdapterDetails.
        :type: str
        """
        self._iot_domain_id = iot_domain_id

    @property
    def digital_twin_model_id(self):
        """
        Gets the digital_twin_model_id of this CreateDigitalTwinAdapterDetails.
        The `OCID`__ of the digital twin model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The digital_twin_model_id of this CreateDigitalTwinAdapterDetails.
        :rtype: str
        """
        return self._digital_twin_model_id

    @digital_twin_model_id.setter
    def digital_twin_model_id(self, digital_twin_model_id):
        """
        Sets the digital_twin_model_id of this CreateDigitalTwinAdapterDetails.
        The `OCID`__ of the digital twin model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param digital_twin_model_id: The digital_twin_model_id of this CreateDigitalTwinAdapterDetails.
        :type: str
        """
        self._digital_twin_model_id = digital_twin_model_id

    @property
    def digital_twin_model_spec_uri(self):
        """
        Gets the digital_twin_model_spec_uri of this CreateDigitalTwinAdapterDetails.
        The URI of the digital twin model specification.


        :return: The digital_twin_model_spec_uri of this CreateDigitalTwinAdapterDetails.
        :rtype: str
        """
        return self._digital_twin_model_spec_uri

    @digital_twin_model_spec_uri.setter
    def digital_twin_model_spec_uri(self, digital_twin_model_spec_uri):
        """
        Sets the digital_twin_model_spec_uri of this CreateDigitalTwinAdapterDetails.
        The URI of the digital twin model specification.


        :param digital_twin_model_spec_uri: The digital_twin_model_spec_uri of this CreateDigitalTwinAdapterDetails.
        :type: str
        """
        self._digital_twin_model_spec_uri = digital_twin_model_spec_uri

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateDigitalTwinAdapterDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateDigitalTwinAdapterDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDigitalTwinAdapterDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateDigitalTwinAdapterDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateDigitalTwinAdapterDetails.
        A short description of the resource.


        :return: The description of this CreateDigitalTwinAdapterDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateDigitalTwinAdapterDetails.
        A short description of the resource.


        :param description: The description of this CreateDigitalTwinAdapterDetails.
        :type: str
        """
        self._description = description

    @property
    def inbound_envelope(self):
        """
        Gets the inbound_envelope of this CreateDigitalTwinAdapterDetails.

        :return: The inbound_envelope of this CreateDigitalTwinAdapterDetails.
        :rtype: oci.iot.models.DigitalTwinAdapterInboundEnvelope
        """
        return self._inbound_envelope

    @inbound_envelope.setter
    def inbound_envelope(self, inbound_envelope):
        """
        Sets the inbound_envelope of this CreateDigitalTwinAdapterDetails.

        :param inbound_envelope: The inbound_envelope of this CreateDigitalTwinAdapterDetails.
        :type: oci.iot.models.DigitalTwinAdapterInboundEnvelope
        """
        self._inbound_envelope = inbound_envelope

    @property
    def inbound_routes(self):
        """
        Gets the inbound_routes of this CreateDigitalTwinAdapterDetails.
        list of inbound routes


        :return: The inbound_routes of this CreateDigitalTwinAdapterDetails.
        :rtype: list[oci.iot.models.DigitalTwinAdapterInboundRoute]
        """
        return self._inbound_routes

    @inbound_routes.setter
    def inbound_routes(self, inbound_routes):
        """
        Sets the inbound_routes of this CreateDigitalTwinAdapterDetails.
        list of inbound routes


        :param inbound_routes: The inbound_routes of this CreateDigitalTwinAdapterDetails.
        :type: list[oci.iot.models.DigitalTwinAdapterInboundRoute]
        """
        self._inbound_routes = inbound_routes

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDigitalTwinAdapterDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateDigitalTwinAdapterDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDigitalTwinAdapterDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateDigitalTwinAdapterDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDigitalTwinAdapterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateDigitalTwinAdapterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDigitalTwinAdapterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateDigitalTwinAdapterDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
