# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReplicateSchemaChange(object):
    """
    Options required for pipeline Initial Data Load. If enabled, copies existing data from source to target before replication.
    """

    #: A constant which can be used with the can_replicate_schema_change property of a ReplicateSchemaChange.
    #: This constant has a value of "ENABLED"
    CAN_REPLICATE_SCHEMA_CHANGE_ENABLED = "ENABLED"

    #: A constant which can be used with the can_replicate_schema_change property of a ReplicateSchemaChange.
    #: This constant has a value of "DISABLED"
    CAN_REPLICATE_SCHEMA_CHANGE_DISABLED = "DISABLED"

    #: A constant which can be used with the action_on_ddl_error property of a ReplicateSchemaChange.
    #: This constant has a value of "TERMINATE"
    ACTION_ON_DDL_ERROR_TERMINATE = "TERMINATE"

    #: A constant which can be used with the action_on_ddl_error property of a ReplicateSchemaChange.
    #: This constant has a value of "DISCARD"
    ACTION_ON_DDL_ERROR_DISCARD = "DISCARD"

    #: A constant which can be used with the action_on_ddl_error property of a ReplicateSchemaChange.
    #: This constant has a value of "IGNORE"
    ACTION_ON_DDL_ERROR_IGNORE = "IGNORE"

    #: A constant which can be used with the action_on_dml_error property of a ReplicateSchemaChange.
    #: This constant has a value of "TERMINATE"
    ACTION_ON_DML_ERROR_TERMINATE = "TERMINATE"

    #: A constant which can be used with the action_on_dml_error property of a ReplicateSchemaChange.
    #: This constant has a value of "DISCARD"
    ACTION_ON_DML_ERROR_DISCARD = "DISCARD"

    #: A constant which can be used with the action_on_dml_error property of a ReplicateSchemaChange.
    #: This constant has a value of "IGNORE"
    ACTION_ON_DML_ERROR_IGNORE = "IGNORE"

    def __init__(self, **kwargs):
        """
        Initializes a new ReplicateSchemaChange object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param can_replicate_schema_change:
            The value to assign to the can_replicate_schema_change property of this ReplicateSchemaChange.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type can_replicate_schema_change: str

        :param action_on_ddl_error:
            The value to assign to the action_on_ddl_error property of this ReplicateSchemaChange.
            Allowed values for this property are: "TERMINATE", "DISCARD", "IGNORE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type action_on_ddl_error: str

        :param action_on_dml_error:
            The value to assign to the action_on_dml_error property of this ReplicateSchemaChange.
            Allowed values for this property are: "TERMINATE", "DISCARD", "IGNORE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type action_on_dml_error: str

        """
        self.swagger_types = {
            'can_replicate_schema_change': 'str',
            'action_on_ddl_error': 'str',
            'action_on_dml_error': 'str'
        }
        self.attribute_map = {
            'can_replicate_schema_change': 'canReplicateSchemaChange',
            'action_on_ddl_error': 'actionOnDdlError',
            'action_on_dml_error': 'actionOnDmlError'
        }
        self._can_replicate_schema_change = None
        self._action_on_ddl_error = None
        self._action_on_dml_error = None

    @property
    def can_replicate_schema_change(self):
        """
        **[Required]** Gets the can_replicate_schema_change of this ReplicateSchemaChange.
        If ENABLED, then addition or removal of schema is also replicated, apart from individual tables and records when creating or updating the pipeline.

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The can_replicate_schema_change of this ReplicateSchemaChange.
        :rtype: str
        """
        return self._can_replicate_schema_change

    @can_replicate_schema_change.setter
    def can_replicate_schema_change(self, can_replicate_schema_change):
        """
        Sets the can_replicate_schema_change of this ReplicateSchemaChange.
        If ENABLED, then addition or removal of schema is also replicated, apart from individual tables and records when creating or updating the pipeline.


        :param can_replicate_schema_change: The can_replicate_schema_change of this ReplicateSchemaChange.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(can_replicate_schema_change, allowed_values):
            can_replicate_schema_change = 'UNKNOWN_ENUM_VALUE'
        self._can_replicate_schema_change = can_replicate_schema_change

    @property
    def action_on_ddl_error(self):
        """
        Gets the action_on_ddl_error of this ReplicateSchemaChange.
        Action upon DDL Error (active only if 'Replicate schema changes (DDL)' is selected) i.e canReplicateSchemaChange=true

        Allowed values for this property are: "TERMINATE", "DISCARD", "IGNORE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The action_on_ddl_error of this ReplicateSchemaChange.
        :rtype: str
        """
        return self._action_on_ddl_error

    @action_on_ddl_error.setter
    def action_on_ddl_error(self, action_on_ddl_error):
        """
        Sets the action_on_ddl_error of this ReplicateSchemaChange.
        Action upon DDL Error (active only if 'Replicate schema changes (DDL)' is selected) i.e canReplicateSchemaChange=true


        :param action_on_ddl_error: The action_on_ddl_error of this ReplicateSchemaChange.
        :type: str
        """
        allowed_values = ["TERMINATE", "DISCARD", "IGNORE"]
        if not value_allowed_none_or_none_sentinel(action_on_ddl_error, allowed_values):
            action_on_ddl_error = 'UNKNOWN_ENUM_VALUE'
        self._action_on_ddl_error = action_on_ddl_error

    @property
    def action_on_dml_error(self):
        """
        Gets the action_on_dml_error of this ReplicateSchemaChange.
        Action upon DML Error (active only if 'Replicate schema changes (DDL)' is selected) i.e canReplicateSchemaChange=true

        Allowed values for this property are: "TERMINATE", "DISCARD", "IGNORE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The action_on_dml_error of this ReplicateSchemaChange.
        :rtype: str
        """
        return self._action_on_dml_error

    @action_on_dml_error.setter
    def action_on_dml_error(self, action_on_dml_error):
        """
        Sets the action_on_dml_error of this ReplicateSchemaChange.
        Action upon DML Error (active only if 'Replicate schema changes (DDL)' is selected) i.e canReplicateSchemaChange=true


        :param action_on_dml_error: The action_on_dml_error of this ReplicateSchemaChange.
        :type: str
        """
        allowed_values = ["TERMINATE", "DISCARD", "IGNORE"]
        if not value_allowed_none_or_none_sentinel(action_on_dml_error, allowed_values):
            action_on_dml_error = 'UNKNOWN_ENUM_VALUE'
        self._action_on_dml_error = action_on_dml_error

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
