# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateIcebergStorageDetails(object):
    """
    The information about a new storage of given type used in an Iceberg connection.
    """

    #: A constant which can be used with the storage_type property of a CreateIcebergStorageDetails.
    #: This constant has a value of "AMAZON_S3"
    STORAGE_TYPE_AMAZON_S3 = "AMAZON_S3"

    #: A constant which can be used with the storage_type property of a CreateIcebergStorageDetails.
    #: This constant has a value of "GOOGLE_CLOUD_STORAGE"
    STORAGE_TYPE_GOOGLE_CLOUD_STORAGE = "GOOGLE_CLOUD_STORAGE"

    #: A constant which can be used with the storage_type property of a CreateIcebergStorageDetails.
    #: This constant has a value of "AZURE_DATA_LAKE_STORAGE"
    STORAGE_TYPE_AZURE_DATA_LAKE_STORAGE = "AZURE_DATA_LAKE_STORAGE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateIcebergStorageDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.golden_gate.models.CreateAzureDataLakeStorageIcebergStorageDetails`
        * :class:`~oci.golden_gate.models.CreateGoogleCloudStorageIcebergStorageDetails`
        * :class:`~oci.golden_gate.models.CreateAmazonS3IcebergStorageDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param storage_type:
            The value to assign to the storage_type property of this CreateIcebergStorageDetails.
            Allowed values for this property are: "AMAZON_S3", "GOOGLE_CLOUD_STORAGE", "AZURE_DATA_LAKE_STORAGE"
        :type storage_type: str

        """
        self.swagger_types = {
            'storage_type': 'str'
        }
        self.attribute_map = {
            'storage_type': 'storageType'
        }
        self._storage_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['storageType']

        if type == 'AZURE_DATA_LAKE_STORAGE':
            return 'CreateAzureDataLakeStorageIcebergStorageDetails'

        if type == 'GOOGLE_CLOUD_STORAGE':
            return 'CreateGoogleCloudStorageIcebergStorageDetails'

        if type == 'AMAZON_S3':
            return 'CreateAmazonS3IcebergStorageDetails'
        else:
            return 'CreateIcebergStorageDetails'

    @property
    def storage_type(self):
        """
        **[Required]** Gets the storage_type of this CreateIcebergStorageDetails.
        The storage type used in the Iceberg connection.

        Allowed values for this property are: "AMAZON_S3", "GOOGLE_CLOUD_STORAGE", "AZURE_DATA_LAKE_STORAGE"


        :return: The storage_type of this CreateIcebergStorageDetails.
        :rtype: str
        """
        return self._storage_type

    @storage_type.setter
    def storage_type(self, storage_type):
        """
        Sets the storage_type of this CreateIcebergStorageDetails.
        The storage type used in the Iceberg connection.


        :param storage_type: The storage_type of this CreateIcebergStorageDetails.
        :type: str
        """
        allowed_values = ["AMAZON_S3", "GOOGLE_CLOUD_STORAGE", "AZURE_DATA_LAKE_STORAGE"]
        if not value_allowed_none_or_none_sentinel(storage_type, allowed_values):
            raise ValueError(
                f"Invalid value for `storage_type`, must be None or one of {allowed_values}"
            )
        self._storage_type = storage_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
