# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResponseJsonSchema(object):
    """
    The JSON schema definition to be used in JSON_SCHEMA response format.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResponseJsonSchema object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this ResponseJsonSchema.
        :type name: str

        :param description:
            The value to assign to the description property of this ResponseJsonSchema.
        :type description: str

        :param schema:
            The value to assign to the schema property of this ResponseJsonSchema.
        :type schema: object

        :param is_strict:
            The value to assign to the is_strict property of this ResponseJsonSchema.
        :type is_strict: bool

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'schema': 'object',
            'is_strict': 'bool'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'schema': 'schema',
            'is_strict': 'isStrict'
        }
        self._name = None
        self._description = None
        self._schema = None
        self._is_strict = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ResponseJsonSchema.
        The name of the response format. Must be a-z, A-Z, 0-9, or contain underscores and dashes.


        :return: The name of this ResponseJsonSchema.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ResponseJsonSchema.
        The name of the response format. Must be a-z, A-Z, 0-9, or contain underscores and dashes.


        :param name: The name of this ResponseJsonSchema.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ResponseJsonSchema.
        A description of what the response format is for, used by the model to determine how to respond in the format.


        :return: The description of this ResponseJsonSchema.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ResponseJsonSchema.
        A description of what the response format is for, used by the model to determine how to respond in the format.


        :param description: The description of this ResponseJsonSchema.
        :type: str
        """
        self._description = description

    @property
    def schema(self):
        """
        Gets the schema of this ResponseJsonSchema.
        The schema used by the structured output, described as a JSON Schema object.


        :return: The schema of this ResponseJsonSchema.
        :rtype: object
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """
        Sets the schema of this ResponseJsonSchema.
        The schema used by the structured output, described as a JSON Schema object.


        :param schema: The schema of this ResponseJsonSchema.
        :type: object
        """
        self._schema = schema

    @property
    def is_strict(self):
        """
        Gets the is_strict of this ResponseJsonSchema.
        Whether to enable strict schema adherence when generating the output. If set to true, the model will always follow the exact schema defined in the schema field. Only a subset of JSON Schema is supported when strict is true.


        :return: The is_strict of this ResponseJsonSchema.
        :rtype: bool
        """
        return self._is_strict

    @is_strict.setter
    def is_strict(self, is_strict):
        """
        Sets the is_strict of this ResponseJsonSchema.
        Whether to enable strict schema adherence when generating the output. If set to true, the model will always follow the exact schema defined in the schema field. Only a subset of JSON Schema is supported when strict is true.


        :param is_strict: The is_strict of this ResponseJsonSchema.
        :type: bool
        """
        self._is_strict = is_strict

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
