# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .tool_call import ToolCall
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FunctionCall(ToolCall):
    """
    The function call generated by the model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FunctionCall object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.FunctionCall.type` attribute
        of this class is ``FUNCTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this FunctionCall.
        :type id: str

        :param type:
            The value to assign to the type property of this FunctionCall.
            Allowed values for this property are: "FUNCTION"
        :type type: str

        :param name:
            The value to assign to the name property of this FunctionCall.
        :type name: str

        :param arguments:
            The value to assign to the arguments property of this FunctionCall.
        :type arguments: str

        """
        self.swagger_types = {
            'id': 'str',
            'type': 'str',
            'name': 'str',
            'arguments': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'type': 'type',
            'name': 'name',
            'arguments': 'arguments'
        }
        self._id = None
        self._type = None
        self._name = None
        self._arguments = None
        self._type = 'FUNCTION'

    @property
    def name(self):
        """
        Gets the name of this FunctionCall.
        The name of the function to call. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.


        :return: The name of this FunctionCall.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FunctionCall.
        The name of the function to call. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.


        :param name: The name of this FunctionCall.
        :type: str
        """
        self._name = name

    @property
    def arguments(self):
        """
        Gets the arguments of this FunctionCall.
        The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.


        :return: The arguments of this FunctionCall.
        :rtype: str
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """
        Sets the arguments of this FunctionCall.
        The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.


        :param arguments: The arguments of this FunctionCall.
        :type: str
        """
        self._arguments = arguments

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
