# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereContentV2(object):
    """
    The base class for the chat content.
    """

    #: A constant which can be used with the type property of a CohereContentV2.
    #: This constant has a value of "TEXT"
    TYPE_TEXT = "TEXT"

    #: A constant which can be used with the type property of a CohereContentV2.
    #: This constant has a value of "IMAGE_URL"
    TYPE_IMAGE_URL = "IMAGE_URL"

    #: A constant which can be used with the type property of a CohereContentV2.
    #: This constant has a value of "DOCUMENT"
    TYPE_DOCUMENT = "DOCUMENT"

    #: A constant which can be used with the type property of a CohereContentV2.
    #: This constant has a value of "THINKING"
    TYPE_THINKING = "THINKING"

    def __init__(self, **kwargs):
        """
        Initializes a new CohereContentV2 object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.generative_ai_inference.models.CohereThinkingContentV2`
        * :class:`~oci.generative_ai_inference.models.CohereTextContentV2`
        * :class:`~oci.generative_ai_inference.models.CohereImageContentV2`
        * :class:`~oci.generative_ai_inference.models.CohereDocumentContentV2`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CohereContentV2.
            Allowed values for this property are: "TEXT", "IMAGE_URL", "DOCUMENT", "THINKING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        """
        self.swagger_types = {
            'type': 'str'
        }
        self.attribute_map = {
            'type': 'type'
        }
        self._type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'THINKING':
            return 'CohereThinkingContentV2'

        if type == 'TEXT':
            return 'CohereTextContentV2'

        if type == 'IMAGE_URL':
            return 'CohereImageContentV2'

        if type == 'DOCUMENT':
            return 'CohereDocumentContentV2'
        else:
            return 'CohereContentV2'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CohereContentV2.
        The type of the content.

        Allowed values for this property are: "TEXT", "IMAGE_URL", "DOCUMENT", "THINKING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this CohereContentV2.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CohereContentV2.
        The type of the content.


        :param type: The type of this CohereContentV2.
        :type: str
        """
        allowed_values = ["TEXT", "IMAGE_URL", "DOCUMENT", "THINKING"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
