# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereCitationToolV2(object):
    """
    A citation source referencing a tool result.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CohereCitationToolV2 object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CohereCitationToolV2.
        :type id: str

        :param tool_output:
            The value to assign to the tool_output property of this CohereCitationToolV2.
        :type tool_output: object

        """
        self.swagger_types = {
            'id': 'str',
            'tool_output': 'object'
        }
        self.attribute_map = {
            'id': 'id',
            'tool_output': 'toolOutput'
        }
        self._id = None
        self._tool_output = None

    @property
    def id(self):
        """
        Gets the id of this CohereCitationToolV2.
        Unique identifier of the tool call.


        :return: The id of this CohereCitationToolV2.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CohereCitationToolV2.
        Unique identifier of the tool call.


        :param id: The id of this CohereCitationToolV2.
        :type: str
        """
        self._id = id

    @property
    def tool_output(self):
        """
        Gets the tool_output of this CohereCitationToolV2.
        Output from the tool.


        :return: The tool_output of this CohereCitationToolV2.
        :rtype: object
        """
        return self._tool_output

    @tool_output.setter
    def tool_output(self, tool_output):
        """
        Sets the tool_output of this CohereCitationToolV2.
        Output from the tool.


        :param tool_output: The tool_output of this CohereCitationToolV2.
        :type: object
        """
        self._tool_output = tool_output

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
