# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereCitationDocument(object):
    """
    A citation source referencing a document.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CohereCitationDocument object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CohereCitationDocument.
        :type id: str

        :param document:
            The value to assign to the document property of this CohereCitationDocument.
        :type document: object

        """
        self.swagger_types = {
            'id': 'str',
            'document': 'object'
        }
        self.attribute_map = {
            'id': 'id',
            'document': 'document'
        }
        self._id = None
        self._document = None

    @property
    def id(self):
        """
        Gets the id of this CohereCitationDocument.
        Unique identifier for the document.


        :return: The id of this CohereCitationDocument.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CohereCitationDocument.
        Unique identifier for the document.


        :param id: The id of this CohereCitationDocument.
        :type: str
        """
        self._id = id

    @property
    def document(self):
        """
        Gets the document of this CohereCitationDocument.
        The actual document content or reference.


        :return: The document of this CohereCitationDocument.
        :rtype: object
        """
        return self._document

    @document.setter
    def document(self, document):
        """
        Sets the document of this CohereCitationDocument.
        The actual document content or reference.


        :param document: The document of this CohereCitationDocument.
        :type: object
        """
        self._document = document

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
