# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .chat_content import ChatContent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AudioContent(ChatContent):
    """
    Represents a single instance of chat audio content.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AudioContent object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.AudioContent.type` attribute
        of this class is ``AUDIO`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this AudioContent.
            Allowed values for this property are: "TEXT", "IMAGE"
        :type type: str

        :param audio_url:
            The value to assign to the audio_url property of this AudioContent.
        :type audio_url: oci.generative_ai_inference.models.AudioUrl

        """
        self.swagger_types = {
            'type': 'str',
            'audio_url': 'AudioUrl'
        }
        self.attribute_map = {
            'type': 'type',
            'audio_url': 'audioUrl'
        }
        self._type = None
        self._audio_url = None
        self._type = 'AUDIO'

    @property
    def audio_url(self):
        """
        Gets the audio_url of this AudioContent.

        :return: The audio_url of this AudioContent.
        :rtype: oci.generative_ai_inference.models.AudioUrl
        """
        return self._audio_url

    @audio_url.setter
    def audio_url(self, audio_url):
        """
        Sets the audio_url of this AudioContent.

        :param audio_url: The audio_url of this AudioContent.
        :type: oci.generative_ai_inference.models.AudioUrl
        """
        self._audio_url = audio_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
