# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelParams(object):
    """
    Details of model parameters.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ModelParams object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param max_tokens:
            The value to assign to the max_tokens property of this ModelParams.
        :type max_tokens: int

        :param temperature:
            The value to assign to the temperature property of this ModelParams.
        :type temperature: float

        :param top_p:
            The value to assign to the top_p property of this ModelParams.
        :type top_p: float

        :param top_k:
            The value to assign to the top_k property of this ModelParams.
        :type top_k: int

        :param frequency_penalty:
            The value to assign to the frequency_penalty property of this ModelParams.
        :type frequency_penalty: float

        :param presence_penalty:
            The value to assign to the presence_penalty property of this ModelParams.
        :type presence_penalty: float

        :param seed:
            The value to assign to the seed property of this ModelParams.
        :type seed: int

        :param reasoning_effort:
            The value to assign to the reasoning_effort property of this ModelParams.
        :type reasoning_effort: str

        :param verbosity:
            The value to assign to the verbosity property of this ModelParams.
        :type verbosity: str

        """
        self.swagger_types = {
            'max_tokens': 'int',
            'temperature': 'float',
            'top_p': 'float',
            'top_k': 'int',
            'frequency_penalty': 'float',
            'presence_penalty': 'float',
            'seed': 'int',
            'reasoning_effort': 'str',
            'verbosity': 'str'
        }
        self.attribute_map = {
            'max_tokens': 'maxTokens',
            'temperature': 'temperature',
            'top_p': 'topP',
            'top_k': 'topK',
            'frequency_penalty': 'frequencyPenalty',
            'presence_penalty': 'presencePenalty',
            'seed': 'seed',
            'reasoning_effort': 'reasoningEffort',
            'verbosity': 'verbosity'
        }
        self._max_tokens = None
        self._temperature = None
        self._top_p = None
        self._top_k = None
        self._frequency_penalty = None
        self._presence_penalty = None
        self._seed = None
        self._reasoning_effort = None
        self._verbosity = None

    @property
    def max_tokens(self):
        """
        Gets the max_tokens of this ModelParams.
        Maximum number of tokens.


        :return: The max_tokens of this ModelParams.
        :rtype: int
        """
        return self._max_tokens

    @max_tokens.setter
    def max_tokens(self, max_tokens):
        """
        Sets the max_tokens of this ModelParams.
        Maximum number of tokens.


        :param max_tokens: The max_tokens of this ModelParams.
        :type: int
        """
        self._max_tokens = max_tokens

    @property
    def temperature(self):
        """
        Gets the temperature of this ModelParams.
        Sampling temperature.


        :return: The temperature of this ModelParams.
        :rtype: float
        """
        return self._temperature

    @temperature.setter
    def temperature(self, temperature):
        """
        Sets the temperature of this ModelParams.
        Sampling temperature.


        :param temperature: The temperature of this ModelParams.
        :type: float
        """
        self._temperature = temperature

    @property
    def top_p(self):
        """
        Gets the top_p of this ModelParams.
        Nucleus sampling probability.


        :return: The top_p of this ModelParams.
        :rtype: float
        """
        return self._top_p

    @top_p.setter
    def top_p(self, top_p):
        """
        Sets the top_p of this ModelParams.
        Nucleus sampling probability.


        :param top_p: The top_p of this ModelParams.
        :type: float
        """
        self._top_p = top_p

    @property
    def top_k(self):
        """
        Gets the top_k of this ModelParams.
        Top-K sampling parameter.


        :return: The top_k of this ModelParams.
        :rtype: int
        """
        return self._top_k

    @top_k.setter
    def top_k(self, top_k):
        """
        Sets the top_k of this ModelParams.
        Top-K sampling parameter.


        :param top_k: The top_k of this ModelParams.
        :type: int
        """
        self._top_k = top_k

    @property
    def frequency_penalty(self):
        """
        Gets the frequency_penalty of this ModelParams.
        Frequency penalty to reduce repeating tokens.


        :return: The frequency_penalty of this ModelParams.
        :rtype: float
        """
        return self._frequency_penalty

    @frequency_penalty.setter
    def frequency_penalty(self, frequency_penalty):
        """
        Sets the frequency_penalty of this ModelParams.
        Frequency penalty to reduce repeating tokens.


        :param frequency_penalty: The frequency_penalty of this ModelParams.
        :type: float
        """
        self._frequency_penalty = frequency_penalty

    @property
    def presence_penalty(self):
        """
        Gets the presence_penalty of this ModelParams.
        Presence penalty to encourage new topics.


        :return: The presence_penalty of this ModelParams.
        :rtype: float
        """
        return self._presence_penalty

    @presence_penalty.setter
    def presence_penalty(self, presence_penalty):
        """
        Sets the presence_penalty of this ModelParams.
        Presence penalty to encourage new topics.


        :param presence_penalty: The presence_penalty of this ModelParams.
        :type: float
        """
        self._presence_penalty = presence_penalty

    @property
    def seed(self):
        """
        Gets the seed of this ModelParams.
        Seed makes best effort to sample tokens deterministically.


        :return: The seed of this ModelParams.
        :rtype: int
        """
        return self._seed

    @seed.setter
    def seed(self, seed):
        """
        Sets the seed of this ModelParams.
        Seed makes best effort to sample tokens deterministically.


        :param seed: The seed of this ModelParams.
        :type: int
        """
        self._seed = seed

    @property
    def reasoning_effort(self):
        """
        Gets the reasoning_effort of this ModelParams.
        Constrains effort on reasoning for reasoning models.


        :return: The reasoning_effort of this ModelParams.
        :rtype: str
        """
        return self._reasoning_effort

    @reasoning_effort.setter
    def reasoning_effort(self, reasoning_effort):
        """
        Sets the reasoning_effort of this ModelParams.
        Constrains effort on reasoning for reasoning models.


        :param reasoning_effort: The reasoning_effort of this ModelParams.
        :type: str
        """
        self._reasoning_effort = reasoning_effort

    @property
    def verbosity(self):
        """
        Gets the verbosity of this ModelParams.
        Constrains the verbosity of the model's response.


        :return: The verbosity of this ModelParams.
        :rtype: str
        """
        return self._verbosity

    @verbosity.setter
    def verbosity(self, verbosity):
        """
        Sets the verbosity of this ModelParams.
        Constrains the verbosity of the model's response.


        :param verbosity: The verbosity of this ModelParams.
        :type: str
        """
        self._verbosity = verbosity

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
