# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .required_action import RequiredAction
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FunctionCallingRequiredAction(RequiredAction):
    """
    Represents an action for submitting function call outputs.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FunctionCallingRequiredAction object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent_runtime.models.FunctionCallingRequiredAction.required_action_type` attribute
        of this class is ``FUNCTION_CALLING_REQUIRED_ACTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_id:
            The value to assign to the action_id property of this FunctionCallingRequiredAction.
        :type action_id: str

        :param required_action_type:
            The value to assign to the required_action_type property of this FunctionCallingRequiredAction.
            Allowed values for this property are: "HUMAN_APPROVAL_REQUIRED_ACTION", "FUNCTION_CALLING_REQUIRED_ACTION"
        :type required_action_type: str

        :param function_call:
            The value to assign to the function_call property of this FunctionCallingRequiredAction.
        :type function_call: oci.generative_ai_agent_runtime.models.FunctionCall

        """
        self.swagger_types = {
            'action_id': 'str',
            'required_action_type': 'str',
            'function_call': 'FunctionCall'
        }
        self.attribute_map = {
            'action_id': 'actionId',
            'required_action_type': 'requiredActionType',
            'function_call': 'functionCall'
        }
        self._action_id = None
        self._required_action_type = None
        self._function_call = None
        self._required_action_type = 'FUNCTION_CALLING_REQUIRED_ACTION'

    @property
    def function_call(self):
        """
        **[Required]** Gets the function_call of this FunctionCallingRequiredAction.

        :return: The function_call of this FunctionCallingRequiredAction.
        :rtype: oci.generative_ai_agent_runtime.models.FunctionCall
        """
        return self._function_call

    @function_call.setter
    def function_call(self, function_call):
        """
        Sets the function_call of this FunctionCallingRequiredAction.

        :param function_call: The function_call of this FunctionCallingRequiredAction.
        :type: oci.generative_ai_agent_runtime.models.FunctionCall
        """
        self._function_call = function_call

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
