# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .performed_action import PerformedAction
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FunctionCallingPerformedAction(PerformedAction):
    """
    Represents an action for recording the result of a function call.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FunctionCallingPerformedAction object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent_runtime.models.FunctionCallingPerformedAction.performed_action_type` attribute
        of this class is ``FUNCTION_CALLING_PERFORMED_ACTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_id:
            The value to assign to the action_id property of this FunctionCallingPerformedAction.
        :type action_id: str

        :param performed_action_type:
            The value to assign to the performed_action_type property of this FunctionCallingPerformedAction.
            Allowed values for this property are: "HUMAN_APPROVAL_PERFORMED_ACTION", "FUNCTION_CALLING_PERFORMED_ACTION"
        :type performed_action_type: str

        :param function_call_output:
            The value to assign to the function_call_output property of this FunctionCallingPerformedAction.
        :type function_call_output: str

        """
        self.swagger_types = {
            'action_id': 'str',
            'performed_action_type': 'str',
            'function_call_output': 'str'
        }
        self.attribute_map = {
            'action_id': 'actionId',
            'performed_action_type': 'performedActionType',
            'function_call_output': 'functionCallOutput'
        }
        self._action_id = None
        self._performed_action_type = None
        self._function_call_output = None
        self._performed_action_type = 'FUNCTION_CALLING_PERFORMED_ACTION'

    @property
    def function_call_output(self):
        """
        **[Required]** Gets the function_call_output of this FunctionCallingPerformedAction.
        The result or output of the function call.


        :return: The function_call_output of this FunctionCallingPerformedAction.
        :rtype: str
        """
        return self._function_call_output

    @function_call_output.setter
    def function_call_output(self, function_call_output):
        """
        Sets the function_call_output of this FunctionCallingPerformedAction.
        The result or output of the function call.


        :param function_call_output: The function_call_output of this FunctionCallingPerformedAction.
        :type: str
        """
        self._function_call_output = function_call_output

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
