# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ToolRuntimeConfig(object):
    """
    Configuration for the tool.
    """

    #: A constant which can be used with the tool_runtime_config_type property of a ToolRuntimeConfig.
    #: This constant has a value of "RAG"
    TOOL_RUNTIME_CONFIG_TYPE_RAG = "RAG"

    #: A constant which can be used with the tool_runtime_config_type property of a ToolRuntimeConfig.
    #: This constant has a value of "SQL_SMALL"
    TOOL_RUNTIME_CONFIG_TYPE_SQL_SMALL = "SQL_SMALL"

    #: A constant which can be used with the tool_runtime_config_type property of a ToolRuntimeConfig.
    #: This constant has a value of "SQL_LARGE"
    TOOL_RUNTIME_CONFIG_TYPE_SQL_LARGE = "SQL_LARGE"

    def __init__(self, **kwargs):
        """
        Initializes a new ToolRuntimeConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_runtime_config_type:
            The value to assign to the tool_runtime_config_type property of this ToolRuntimeConfig.
            Allowed values for this property are: "RAG", "SQL_SMALL", "SQL_LARGE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type tool_runtime_config_type: str

        :param version:
            The value to assign to the version property of this ToolRuntimeConfig.
        :type version: str

        """
        self.swagger_types = {
            'tool_runtime_config_type': 'str',
            'version': 'str'
        }
        self.attribute_map = {
            'tool_runtime_config_type': 'toolRuntimeConfigType',
            'version': 'version'
        }
        self._tool_runtime_config_type = None
        self._version = None

    @property
    def tool_runtime_config_type(self):
        """
        **[Required]** Gets the tool_runtime_config_type of this ToolRuntimeConfig.
        The type of the tool.

        Allowed values for this property are: "RAG", "SQL_SMALL", "SQL_LARGE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The tool_runtime_config_type of this ToolRuntimeConfig.
        :rtype: str
        """
        return self._tool_runtime_config_type

    @tool_runtime_config_type.setter
    def tool_runtime_config_type(self, tool_runtime_config_type):
        """
        Sets the tool_runtime_config_type of this ToolRuntimeConfig.
        The type of the tool.


        :param tool_runtime_config_type: The tool_runtime_config_type of this ToolRuntimeConfig.
        :type: str
        """
        allowed_values = ["RAG", "SQL_SMALL", "SQL_LARGE"]
        if not value_allowed_none_or_none_sentinel(tool_runtime_config_type, allowed_values):
            tool_runtime_config_type = 'UNKNOWN_ENUM_VALUE'
        self._tool_runtime_config_type = tool_runtime_config_type

    @property
    def version(self):
        """
        Gets the version of this ToolRuntimeConfig.
        The version of the components.


        :return: The version of this ToolRuntimeConfig.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ToolRuntimeConfig.
        The version of the components.


        :param version: The version of this ToolRuntimeConfig.
        :type: str
        """
        self._version = version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
