# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .fsu_readiness_check import FsuReadinessCheck
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetFsuReadinessCheck(FsuReadinessCheck):
    """
    Patch Exadata Fleet Update Readiness Check resource details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TargetFsuReadinessCheck object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.TargetFsuReadinessCheck.type` attribute
        of this class is ``TARGET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this TargetFsuReadinessCheck.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this TargetFsuReadinessCheck.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this TargetFsuReadinessCheck.
        :type compartment_id: str

        :param type:
            The value to assign to the type property of this TargetFsuReadinessCheck.
            Allowed values for this property are: "TARGET"
        :type type: str

        :param issue_count:
            The value to assign to the issue_count property of this TargetFsuReadinessCheck.
        :type issue_count: int

        :param issues:
            The value to assign to the issues property of this TargetFsuReadinessCheck.
        :type issues: list[oci.fleet_software_update.models.PatchingIssueEntry]

        :param time_created:
            The value to assign to the time_created property of this TargetFsuReadinessCheck.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this TargetFsuReadinessCheck.
        :type time_updated: datetime

        :param time_finished:
            The value to assign to the time_finished property of this TargetFsuReadinessCheck.
        :type time_finished: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this TargetFsuReadinessCheck.
            Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "FAILED", "NEEDS_ATTENTION", "SUCCEEDED", "WAITING", "CANCELING", "CANCELED", "DELETING", "DELETED"
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this TargetFsuReadinessCheck.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this TargetFsuReadinessCheck.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this TargetFsuReadinessCheck.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this TargetFsuReadinessCheck.
        :type system_tags: dict(str, dict(str, object))

        :param targets:
            The value to assign to the targets property of this TargetFsuReadinessCheck.
        :type targets: list[oci.fleet_software_update.models.ReadinessCheckTargetEntry]

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'type': 'str',
            'issue_count': 'int',
            'issues': 'list[PatchingIssueEntry]',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_finished': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'targets': 'list[ReadinessCheckTargetEntry]'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'type': 'type',
            'issue_count': 'issueCount',
            'issues': 'issues',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_finished': 'timeFinished',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'targets': 'targets'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._type = None
        self._issue_count = None
        self._issues = None
        self._time_created = None
        self._time_updated = None
        self._time_finished = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._targets = None
        self._type = 'TARGET'

    @property
    def targets(self):
        """
        **[Required]** Gets the targets of this TargetFsuReadinessCheck.
        List of targets that will run the Exadata Fleet Update Readiness Check.
        The targets have to be of the same entity type.


        :return: The targets of this TargetFsuReadinessCheck.
        :rtype: list[oci.fleet_software_update.models.ReadinessCheckTargetEntry]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """
        Sets the targets of this TargetFsuReadinessCheck.
        List of targets that will run the Exadata Fleet Update Readiness Check.
        The targets have to be of the same entity type.


        :param targets: The targets of this TargetFsuReadinessCheck.
        :type: list[oci.fleet_software_update.models.ReadinessCheckTargetEntry]
        """
        self._targets = targets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
