# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReadinessCheckTargetEntry(object):
    """
    Details to specify a target to include in the Exadata Fleet Update Readiness Check run.
    """

    #: A constant which can be used with the entity_type property of a ReadinessCheckTargetEntry.
    #: This constant has a value of "DATABASE"
    ENTITY_TYPE_DATABASE = "DATABASE"

    def __init__(self, **kwargs):
        """
        Initializes a new ReadinessCheckTargetEntry object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entity_type:
            The value to assign to the entity_type property of this ReadinessCheckTargetEntry.
            Allowed values for this property are: "DATABASE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type entity_type: str

        :param entity_id:
            The value to assign to the entity_id property of this ReadinessCheckTargetEntry.
        :type entity_id: str

        """
        self.swagger_types = {
            'entity_type': 'str',
            'entity_id': 'str'
        }
        self.attribute_map = {
            'entity_type': 'entityType',
            'entity_id': 'entityId'
        }
        self._entity_type = None
        self._entity_id = None

    @property
    def entity_type(self):
        """
        **[Required]** Gets the entity_type of this ReadinessCheckTargetEntry.
        Resource entity type

        Allowed values for this property are: "DATABASE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The entity_type of this ReadinessCheckTargetEntry.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """
        Sets the entity_type of this ReadinessCheckTargetEntry.
        Resource entity type


        :param entity_type: The entity_type of this ReadinessCheckTargetEntry.
        :type: str
        """
        allowed_values = ["DATABASE"]
        if not value_allowed_none_or_none_sentinel(entity_type, allowed_values):
            entity_type = 'UNKNOWN_ENUM_VALUE'
        self._entity_type = entity_type

    @property
    def entity_id(self):
        """
        **[Required]** Gets the entity_id of this ReadinessCheckTargetEntry.
        Resource identifier `OCID`__

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The entity_id of this ReadinessCheckTargetEntry.
        :rtype: str
        """
        return self._entity_id

    @entity_id.setter
    def entity_id(self, entity_id):
        """
        Sets the entity_id of this ReadinessCheckTargetEntry.
        Resource identifier `OCID`__

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param entity_id: The entity_id of this ReadinessCheckTargetEntry.
        :type: str
        """
        self._entity_id = entity_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
